package com.yeejoin.amos.boot.module.cylinder.flc.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.cylinder.api.dto.KeyValueDto;
import com.yeejoin.amos.boot.module.cylinder.flc.api.entity.CylinderAreaData;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 气瓶区域统计表 Mapper 接口
 *
 * @author system_generator
 * @date 2022-03-08
 */
public interface CylinderAreaDataMapper extends BaseMapper<CylinderAreaData> {


    Map<String, Object> getInspectionExpiredRate(@Param(value = "regionCode") String regionCode, @Param(value = "appId") String appId);

    Map<String, Object> getInspectionResultRate(@Param(value = "regionCode") String regionCode, @Param(value = "appId") String appId);

    /**
     * 查询单个单位的有效期信息
     *
     * @param appId 公司唯一标识
     * @return KeyValueDto
     */
    KeyValueDto queryLicenseEfficiencyOneCompany(@Param(value = "appId") String appId);


    /**
     * 单位按照资质状态分组下的统计数量
     *
     * @param regionCode 区域
     * @return List<KeyValueDto>
     */
    List<KeyValueDto> queryLicenseEfficiencyOfRegion(@Param(value = "regionCode") String regionCode);

}
