package com.yeejoin.amos.boot.module.jg.api.service;

import java.util.List;
import java.util.Set;

/**
 * @author Administrator
 */
public interface IEquipUsedCheck {

    /**
     * 并发校验（页面同时提交或者页面同时打开多个时，某些设备都是为使用状态）校验设备流程在用状态及更新不在用为再使用状态
     * @param record 设备唯一标识
     * @param companyCode 登录人的公司代码
     */
    void equipRepeatUsedCheck(String record, String companyCode);

    /**
     * 删除流程中的数据，释放redis空间（异常处理及驳回到发起节点、撤回到发起节点、完成时时进行）
     * @param records 设备唯一标识
     * @param companyCode 登录人的公司代码
     */
    void delDataForCheckEquipRepeatUsed(List<String> records, String companyCode);

    /**
     * 获取在流程中的设备
     * @param companyCode 公司编码
     * @return 在用的设备集合
     */
    Set<String> getEquipInFlow(String companyCode);

    /**
     * 可处理的业务类型
     * @return String
     */
    String applyBizType();

    /**
     * 数据初始化方法
     */
    void init();

    /**
     * 删除流程中的数据，释放redis空间（异常处理及驳回到发起节点、撤回到发起节点、完成时时进行）
     *
     * @param records     设备唯一标识
     * @param redisKey   key
     */
    void delDataForCheckWithKey(List<String> records, String redisKey);
}
