package com.yeejoin.amos.boot.module.jyjc.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author LiuLin
 */

@AllArgsConstructor
@Getter
public enum JYJCTypeEnum {

    /**
     * 检验检测类型
     */
    DTJC("DTJC", "电梯检测","jc"),
    DQJY("DQJY", "定期检验", "jy"),
    SCJY("SCJY", "首次检验", "jy"),
    WXJDJY("WXJDJY", "维修监督检验", "jy"),
    GZJDJY("GZJDJY", "改造监督检验", "jy"),
    AZJDJY("AZJDJY", "安装监督检验", "jy");

    private final String code;
    private final String name;

    private final String bizType;

    public static JYJCTypeEnum of(String code) {
        for (JYJCTypeEnum e : JYJCTypeEnum.values()) {
            if (e.getCode().equals(code)) {
                return e;
            }
        }
        return null;
    }
}
