package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Sequence;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jyjc.api.common.StringUtil;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResult;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResultAttachment;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResultParam;
import com.yeejoin.amos.boot.module.jyjc.api.enums.EquipCategoryEnum;
import com.yeejoin.amos.boot.module.jyjc.api.enums.ResultStatusEnum;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionResultMapper;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionResultDataModel;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionResultModel;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionResultAttachmentService;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionResultParamService;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionResultService;
import com.yeejoin.amos.boot.module.jyjc.biz.event.InspectionDetectionSaveToDbEvent;
import com.yeejoin.amos.boot.module.jyjc.biz.event.UseInfoSaveToDbEvent;
import com.yeejoin.amos.boot.module.jyjc.biz.event.publisher.BizEmqPublisher;
import com.yeejoin.amos.boot.module.jyjc.biz.event.publisher.EventPublisher;
import com.yeejoin.amos.boot.module.jyjc.biz.util.JsonUtils;
import com.yeejoin.amos.boot.module.ymt.api.entity.InspectionDetectionInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzsUserInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.EquipmentClassifityEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 业务开通申请表服务实现类
 *
 * @author system_generator
 * @date 2023-12-14
 */
@Service
@Slf4j
public class JyjcInspectionResultServiceImpl extends BaseService<JyjcInspectionResultModel, JyjcInspectionResult, JyjcInspectionResultMapper> implements IJyjcInspectionResultService {

    private static final String JYJC_SUBMIT_FILE_PREFIX = "JYJC_";
    private static final String JYJC_SUBMIT_FILE_JYBG = "JYBG";
    private static final String JYJC_SUBMIT_KEY = "inspectResult";
    private static final String JYJC_RESULT_STATUS = "2";

    @Autowired
    private IJyjcInspectionResultAttachmentService iJyjcInspectionResultAttachmentService;

    @Autowired
    private IJyjcInspectionResultParamService iJyjcInspectionResultParamService;

    @Autowired
    EquipmentCategoryMapper equipmentCategoryMapper;

    @Value("classpath:/json/equipCategory.json")
    private Resource equipCategory;

    @Autowired
    JyjcInspectionResultMapper resultMapper;

    @Autowired
    JyjcInspectionResultParamServiceImpl resultParamService;
    @Autowired
    JyjcInspectionResultAttachmentServiceImpl attachmentService;
    @Autowired
    private RedisUtils redisUtils;
    @Autowired
    UseInfoMapper useInfoMapper;
    @Autowired
    CategoryOtherInfoMapper categoryOtherInfoMapper;

    @Autowired
    InspectionDetectionInfoMapper inspectionDetectionInfoMapper;

    @Autowired
    private Sequence sequence;

    @Autowired
    TzBaseEnterpriseInfoMapper tzBaseEnterpriseInfoMapper;

    @Autowired
    CommonServiceImpl commonService;

    @Autowired
    TzsUserInfoMapper tzsUserInfoMapper;

    @Autowired
    EventPublisher eventPublisher;

    @Autowired
    BizEmqPublisher bizEmqPublisher;

    /**
     * 检验检测单位分页查询
     */
    public Page<JyjcInspectionResultModel> queryForJyjcInspectionResultPage(Page<JyjcInspectionResultModel> page, JyjcInspectionResultModel model, boolean type) {
        ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(),
                RequestContext.getToken())).toString(), ReginParams.class);
        if (ObjectUtils.isEmpty(model)) {
            model = new JyjcInspectionResultModel();
        }
        if (type) {
            //检验检测单位分页查询
            model.setInspectionUnitCode(reginParams.getCompany().getCompanyCode());
        } else {
            //报检单位分页查询
            model.setApplicationUnitCode(reginParams.getCompany().getCompanyCode());
        }
        Page<JyjcInspectionResultModel> resultPage = resultMapper.selectJyjcInspectionResultpPage(page, model);
        resultPage.getRecords().forEach(v -> {
            if (ResultStatusEnum.NO_RESULT.getCode().equals(v.getResultStatus())) {
                v.setResultStatusName(ResultStatusEnum.NO_RESULT.getName());
            }
            if (ResultStatusEnum.YES_RESULT.getCode().equals(v.getResultStatus())) {
                v.setResultStatusName(ResultStatusEnum.YES_RESULT.getName());
            }
        });
        return resultPage;
    }

    public Page<JyjcInspectionResultModel> queryForPageList(Page<JyjcInspectionResultModel> page, JyjcInspectionResultModel model) {
        ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(),
                RequestContext.getToken())).toString(), ReginParams.class);
        if (ObjectUtils.isEmpty(model)) {
            model = new JyjcInspectionResultModel();
        }
        // 判断当前登录人身份（报检机构、接收机构、即时报检又是接收机构、都不是（不存在此情况））
        String identity = this.getCompanyIdentityByType(reginParams.getCompany().getCompanyType());
        model.setCompanyCode(reginParams.getCompany().getCompanyCode());
        Page<JyjcInspectionResultModel> resultPage = resultMapper.selectForPage(page, model, identity);
        resultPage.getRecords().forEach(v -> {
            if (ResultStatusEnum.NO_RESULT.getCode().equals(v.getResultStatus())) {
                v.setResultStatusName(ResultStatusEnum.NO_RESULT.getName());
            }
            if (ResultStatusEnum.YES_RESULT.getCode().equals(v.getResultStatus())) {
                v.setResultStatusName(ResultStatusEnum.YES_RESULT.getName());
            }
            v.setIdentity(identity);
        });
        return resultPage;
    }

    private String getCompanyIdentityByType(String companyType) {
        // 可发起单位的单位类型（角色与单位类型已绑定，在业务系统增加的账号不会出现角色与的单位类型不匹配场景）
        String[] applyIdentityDefine = {"使用单位", "安装改造维修单位"};
        // 可进行检验检测申请接收的单位类型，在业务系统增加的账号不会出现角色与的单位类型不匹配场景
        String[] receiveIdentityDefine = {"检验检测机构"};
        boolean isApplyIdentityMatch = false;
        boolean isReceiveIdentityMatch = false;
        if (Arrays.stream(applyIdentityDefine).anyMatch(companyType::contains)) {
            isApplyIdentityMatch = true;
        }
        if (Arrays.stream(receiveIdentityDefine).anyMatch(companyType::contains)) {
            isReceiveIdentityMatch = true;
        }
        if (isApplyIdentityMatch && !isReceiveIdentityMatch) {
            return "apply";
        }
        if (!isApplyIdentityMatch && isReceiveIdentityMatch) {
            return "receive";
        }
        if (isApplyIdentityMatch) {
            return "all";
        }
        return "no";
    }


    @Transactional(rollbackFor = Exception.class)
    public JyjcInspectionResultModel updateJyjcInspectionResult(Map<String, Map<String, Object>> tableModel) {

        Map<String, Object> map = tableModel.get(JYJC_SUBMIT_KEY);

        JyjcInspectionResultModel model = BeanUtil.mapToBean(map, JyjcInspectionResultModel.class, true);
        String inspector = model.getInspector();
        if (StringUtil.isNotEmpty(inspector)) {
            List jsonArray = JSONArray.parseArray(inspector);
            Object inspectors = jsonArray.stream().map(String::valueOf).collect(Collectors.joining(","));
            model.setInspector(String.valueOf(inspectors));
        }
        model.setResultStatus(JYJC_RESULT_STATUS);

        // 更新结果主表
        updateWithModel(model);

        // 更新附件表
        List<JyjcInspectionResultAttachment> attachmentList = new ArrayList<>();
        LambdaQueryWrapper<JyjcInspectionResultAttachment> fileWrapper = new LambdaQueryWrapper<>();
        fileWrapper.eq(JyjcInspectionResultAttachment::getResultSeq, model.getSequenceNbr());
        List<JyjcInspectionResultAttachment> fileList = attachmentService.list(fileWrapper);
        JyjcInspectionResultAttachment jybgFile = new JyjcInspectionResultAttachment();

        map.forEach((k, v) -> {
            if (k.contains(JYJC_SUBMIT_FILE_PREFIX)) {
                JyjcInspectionResultAttachment attachment = new JyjcInspectionResultAttachment();
                attachment.setResultSeq(model.getSequenceNbr());
                attachment.setAttachmentUrl(JSON.toJSONString(map.get(k)));
                attachment.setAttachmentType(k);
                // 新增时需要判断之前有就更新
                if (!CollectionUtils.isEmpty(fileList)) {
                    List<JyjcInspectionResultAttachment> collect = fileList.stream().filter(obj -> k.equals(obj.getAttachmentType())).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(collect)) {
                        JyjcInspectionResultAttachment jyjcInspectionResultAttachment = collect.get(0);
                        attachment.setSequenceNbr(jyjcInspectionResultAttachment.getSequenceNbr());
                    }
                }
                attachmentList.add(attachment);
                if (k.contains(JYJC_SUBMIT_FILE_JYBG)) {
                    jybgFile.setAttachmentUrl(JSON.toJSONString(map.get(k)));
                    attachment.setAttachmentType(k);
                }
            }
        });
        if (!CollectionUtils.isEmpty(attachmentList)) {
            attachmentService.saveOrUpdateBatch(attachmentList);
        }

        // 更新参数表
        LambdaQueryWrapper<JyjcInspectionResultParam> paramWrapper = new LambdaQueryWrapper<>();
        paramWrapper.eq(JyjcInspectionResultParam::getResultSeq, model.getSequenceNbr());
        List<JyjcInspectionResultParam> params = resultParamService.list(paramWrapper);
        List<JyjcInspectionResultParam> paramList = new ArrayList<>();
        tableModel.forEach((k, v) -> {
            if (!JYJC_SUBMIT_KEY.equals(k) && !ObjectUtils.isEmpty(tableModel.get(k))) {
                List<JyjcInspectionResultParam> collect = params.stream().filter(p -> k.equals(p.getParamType())).collect(Collectors.toList());
                JyjcInspectionResultParam resultParam = new JyjcInspectionResultParam();
                if (!CollectionUtils.isEmpty(collect)) {
                    resultParam.setSequenceNbr(collect.get(0).getSequenceNbr());
                }
                resultParam.setParamType(k);
                resultParam.setResultSeq(model.getSequenceNbr());
                resultParam.setParamJson(JSON.toJSONString(tableModel.get(k)));
                paramList.add(resultParam);
            }
        });
        if (!CollectionUtils.isEmpty(paramList)) {
            resultParamService.saveOrUpdateBatch(paramList);
        }

        //插入操作历史记录
        InspectionDetectionInfo info = new InspectionDetectionInfo();
        QueryWrapper<InspectionDetectionInfo> wrapper = new QueryWrapper<>();
        wrapper.lambda().eq(InspectionDetectionInfo::getInspectReportNo, model.getResultNo());
        List<InspectionDetectionInfo> list = inspectionDetectionInfoMapper.selectList(wrapper);
        if (CollectionUtils.isEmpty(list)) {
            extracted(model, info, jybgFile);
            info.setSequenceNbr(sequence.nextId() + "");
            inspectionDetectionInfoMapper.insert(info);
            // 对方不查询库 所以无事务操作
            bizEmqPublisher.sendInspectionMsgAfterSave(info, "insert");
        } else {
            info = list.get(0);
            extracted(model, info, jybgFile);
            inspectionDetectionInfoMapper.updateById(info);
            // 对方不查询库 所以无事务操作
            bizEmqPublisher.sendInspectionMsgAfterSave(info, "update");
        }
        //更新使用信息表
        useInfoMapper.updateByRecord(model.getEquipUnicode(), model.getNextInspectionDate(), model.getInspectionType(), model.getApplicationNo());
        return model;
    }

    private void extracted(JyjcInspectionResultModel model, InspectionDetectionInfo info, JyjcInspectionResultAttachment jybgFile) {
        info.setInspectOrgName(model.getInspectionUnitName());
        info.setInspectType(model.getInspectionType());
        info.setRecord(model.getEquipUnicode());
        info.setInspectDate(model.getInspectionDate());
        info.setInspectStaff(getInspectUserName(model));
        info.setInspectStaffCode(model.getInspector());
        info.setInspectReport(jybgFile.getAttachmentUrl());
        info.setInspectConclusion(model.getInspectionConclusion());
        info.setProblemRemark(model.getNonConformance());
        info.setNextInspectDate(model.getNextInspectionDate());
        info.setSequenceCode(model.getEquipUnicode());
        info.setInspectOrgCode(model.getInspectionUnitCode());
        info.setInspectReportNo(model.getResultNo());
        info.setRecDate(new Date());
    }

    private String getInspectUserName(JyjcInspectionResultModel model) {
        List<TzsUserInfo> userInfos = commonService.getUserInfosByUnitCode(model.getInspectionUnitCode());
        return userInfos.stream().filter(u -> model.getInspector().contains(u.getSequenceNbr() + "")).map(TzsUserInfo::getName).collect(Collectors.joining(","));
    }

    /**
     * 列表查询 示例
     */
    public List<JyjcInspectionResultModel> queryForJyjcInspectionResultList() {
        return this.queryForList("", false);
    }

    @Override
    public Map<String, Object> queryDetailBySeq(Long sequenceNbr) {
        Map<String, Object> map = new HashMap<>();
        Map<String, Object> resultMap = new HashMap<>(9);

        JyjcInspectionResultModel jyjcInspectionResultModel = this.queryBySeq(sequenceNbr);
        if (!ObjectUtils.isEmpty(jyjcInspectionResultModel)) {
            // 对象转map
            map = BeanUtil.beanToMap(jyjcInspectionResultModel);

            // 获取附件
            List<JyjcInspectionResultAttachment> attachmentList = iJyjcInspectionResultAttachmentService.getObjByResultSeq(sequenceNbr);
            if (!CollectionUtils.isEmpty(attachmentList)) {
                Map<String, Object> attachmentMap = attachmentList.stream().map(obj -> {
                    if (StringUtil.isNotEmpty(obj.getAttachmentUrl())) {
                        obj.setAttachmentUrlList(JSONArray.parseArray(obj.getAttachmentUrl()));
                    }
                    return obj;
                }).collect(Collectors.toMap(JyjcInspectionResultAttachment::getAttachmentType, JyjcInspectionResultAttachment::getAttachmentUrlList));
                map.putAll(attachmentMap);
            }

            // 获取技术参数
            List<JyjcInspectionResultParam> paramList = iJyjcInspectionResultParamService.getParamByResultSeq(sequenceNbr);
            if (!CollectionUtils.isEmpty(paramList)) {
                Map<String, Object> finalMap = map;
                paramList.forEach(param -> {
                    if (!ObjectUtils.isEmpty(param.getParamJson())) {
                        JSONObject paramObj = JSON.parseObject(String.valueOf(param.getParamJson()));
                        paramObj.put("equList", finalMap.get("equList"));
                        paramObj.put("equCategory", finalMap.get("equCategory"));
                        resultMap.put(param.getParamType(), paramObj);
                    }
                });
            }
        }
        resultMap.put(JYJC_SUBMIT_KEY, map);
        return resultMap;
    }

    @Override
    public List<Map<String, Object>> equipList(String type, String notNode) {
        List<Map<String, Object>> menus = new ArrayList<>();
        Map<String, List<Map<String, Object>>> resourceJson = JsonUtils.getResourceJson(equipCategory);
        List<Map<String, Object>> mapList;
        if (ValidationUtil.isEmpty(type)) {
            mapList = resourceJson.get(EquipmentClassifityEnum.BDLS.getCode());
        } else {
            mapList = resourceJson.get(type);
        }

        mapList.stream().filter(map -> {
            if (!ObjectUtils.isEmpty(notNode)) {
                String[] code = notNode.split(",");
                List<String> codeList = Arrays.asList(code);
                return !codeList.contains(map.get("code"));
            }
            return true;
        }).forEach(obj -> {
            Map<String, Object> resultMap = new HashMap<>(2);
            resultMap.put("instanceName", obj.get("name"));
            resultMap.put("instanceId", obj.get("code"));
            menus.add(resultMap);
        });

        return menus;
    }

    @Transactional(rollbackFor = Exception.class)
    public List<JyjcInspectionResultDataModel> receivePushResultData(List<JyjcInspectionResultDataModel> resultDataModels) {
        log.info("收到检验检测厂商推送的结果数据：{}", JSONArray.toJSONString(resultDataModels));
        // 1.组织数据
        Map<String, JyjcInspectionResult> resultListMap = queryWaitUpdateResultList(resultDataModels);
        List<JyjcInspectionResultAttachment> resultAttachments = new ArrayList<>();
        List<JyjcInspectionResultParam> resultParams = new ArrayList<>();
        resultDataModels.forEach(r -> {
            // 填充主表数据
            this.fillResultData(r, resultListMap.get(r.getApplicationNo() + ":" + r.getSupervisoryCode()));
            // 填充附件数据
            this.fillResultAttachmentData(r, resultListMap.get(r.getApplicationNo() + ":" + r.getSupervisoryCode()), resultAttachments);
            // 填充技术参数数据
            this.fillResultParamData(r, resultListMap.get(r.getApplicationNo() + ":" + r.getSupervisoryCode()), resultParams);
        });
        // 2.批量保存主表数据
        this.updateBatchById(resultListMap.values());
        // 3.批量保存子表数据
        deleteAndCreateSubTable(resultListMap, resultAttachments, resultParams);
        // 4.异步更新最新一次检验信息
        eventPublisher.publish(new UseInfoSaveToDbEvent(this, new ArrayList<>(resultListMap.values())));
        // 5.异步更新设备的检验检测信息
        eventPublisher.publish(new InspectionDetectionSaveToDbEvent(this, new ArrayList<>(resultListMap.values())));
        return resultDataModels;
    }

    private void deleteAndCreateSubTable(Map<String, JyjcInspectionResult> resultListMap, List<JyjcInspectionResultAttachment> resultAttachments, List<JyjcInspectionResultParam> resultParams) {
        List<JyjcInspectionResult> resultList = new ArrayList<>(resultListMap.values());
        List<Long> resultIds = resultList.stream().map(BaseEntity::getSequenceNbr).collect(Collectors.toList());
        if(resultAttachments.size() > 0){
            attachmentService.remove(new LambdaQueryWrapper<JyjcInspectionResultAttachment>().in(JyjcInspectionResultAttachment::getResultSeq,resultIds));
            attachmentService.saveBatch(resultAttachments);
        }
        if(resultParams.size() >0){
            resultParamService.remove(new LambdaQueryWrapper<JyjcInspectionResultParam>().in(JyjcInspectionResultParam::getResultSeq, resultIds));
            resultParamService.saveBatch(resultParams);
        }
    }


    private void fillResultParamData(JyjcInspectionResultDataModel r, JyjcInspectionResult jyjcInspectionResult, List<JyjcInspectionResultParam> resultParams) {
        JyjcInspectionResultParam resultParam = new JyjcInspectionResultParam();
        resultParam.setResultSeq(jyjcInspectionResult.getSequenceNbr());
        resultParam.setParamJson(JSON.toJSONString(r.getTechParams()));
        resultParam.setRecUserId(RequestContext.getExeUserId());
        resultParam.setRecDate(new Date());
        resultParam.setRemark("同步数据");
        // 将设备种类code换成技术参数枚举
        resultParam.setParamType(this.getTypeByEquipList(jyjcInspectionResult.getEquList()));
        resultParams.add(resultParam);
    }

    private String getTypeByEquipList(String equList) {
        EquipCategoryEnum categoryEnum = EquipCategoryEnum.of(Integer.parseInt(equList));
        assert categoryEnum != null;
        // 前端为枚举类名称的驼峰形式且首字母大写，故进行格式转化换
        return StrUtil.upperFirst(StrUtil.toCamelCase(categoryEnum.name()));
    }

    private void fillResultAttachmentData(JyjcInspectionResultDataModel r, JyjcInspectionResult jyjcInspectionResult, List<JyjcInspectionResultAttachment> resultAttachments) {
        r.getAttachments().forEach(a -> {
            JyjcInspectionResultAttachment attachment = new JyjcInspectionResultAttachment();
            attachment.setResultSeq(jyjcInspectionResult.getSequenceNbr());
            attachment.setAttachmentType(a.getAttachmentType());
            attachment.setAttachmentUrl(JSON.toJSONString(a.getAttachmentContent()));
            attachment.setRecUserId(RequestContext.getExeUserId());
            attachment.setRecDate(new Date());
            attachment.setRemark("同步数据");
            resultAttachments.add(attachment);
        });
    }

    private void fillResultData(JyjcInspectionResultDataModel r, JyjcInspectionResult jyjcInspectionResult) {
        jyjcInspectionResult.setResultStatus(ResultStatusEnum.YES_RESULT.getCode());
        jyjcInspectionResult.setLicenseNumber(r.getLicenseNumber());
        jyjcInspectionResult.setResultNo(r.getResultNo());
        jyjcInspectionResult.setInnerPersonCode(r.getInnerPersonCode());
        jyjcInspectionResult.setInspector(this.getUserSeqByPersonCode(r.getInnerPersonCode()));
        jyjcInspectionResult.setInspectionConclusion(r.getInspectionConclusion());
        jyjcInspectionResult.setInspectionDate(r.getInspectionDate());
        jyjcInspectionResult.setNextInspectionDate(r.getNextInspectionDate());
        jyjcInspectionResult.setInspectionStartDate(r.getInspectionStartDate());
        jyjcInspectionResult.setInspectionEndDate(r.getInspectionEndDate());
        jyjcInspectionResult.setInspectionResultSummary(r.getInspectionResultSummary());
        jyjcInspectionResult.setNonConformance(JSON.toJSONString(r.getNonConformance()));
        jyjcInspectionResult.setRemark("同步数据");
        jyjcInspectionResult.setTraceId(r.getTraceId());
    }

    private String getUserSeqByPersonCode(String innerPersonCode) {
        if(StrUtil.isNotEmpty(innerPersonCode)){
            List<TzsUserInfo> tzsUserInfos = tzsUserInfoMapper.selectList(new LambdaQueryWrapper<TzsUserInfo>().in(TzsUserInfo::getInnerPersonCode, Arrays.asList(innerPersonCode.split(","))));
            return tzsUserInfos.stream().map(u -> u.getSequenceNbr() + "").collect(Collectors.joining(","));
        }
         log.error("检验人员内部编号为空");
        return "";
    }

    private Map<String, JyjcInspectionResult> queryWaitUpdateResultList(List<JyjcInspectionResultDataModel> resultDataModels) {
        List<String> applicationNos = resultDataModels.stream().map(JyjcInspectionResultDataModel::getApplicationNo).collect(Collectors.toList());
        List<String> supervisoryCodes = resultDataModels.stream().map(JyjcInspectionResultDataModel::getSupervisoryCode).collect(Collectors.toList());
        LambdaQueryWrapper<JyjcInspectionResult> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(JyjcInspectionResult::getApplicationNo, applicationNos);
        wrapper.in(JyjcInspectionResult::getSupervisoryCode, supervisoryCodes);
        List<JyjcInspectionResult> resultList = this.list(wrapper);
        return resultList.stream().collect(Collectors.toMap((c)-> c.getApplicationNo() + ":" + c.getSupervisoryCode(), Function.identity()));
    }
}