package com.yeejoin.amos.boot.module.jg.api.dto;

import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 安全追溯-索道
 *
 * @author system_generator
 * @date 2023-08-17
 */
@EqualsAndHashCode(callSuper = true)
@Data
@Accessors(chain = true)
@Group(value = "tech_params_ropeway")
public class TechParamsRopewayChangeFieldDto extends BaseTechParamsFieldDto {

    @FieldDisplayDefine(value = "平距")
    private String horizontalDistance;

    @FieldDisplayDefine(value = "支架数目")
    private Integer supportsCount;

    @FieldDisplayDefine(value = "斜长")
    private String obliqueLength;

    @FieldDisplayDefine(value = "主电机型式")
    private String mainMotorModel;

    @FieldDisplayDefine(value = "主电机功率")
    private String mainMotorPower;

    @FieldDisplayDefine(value = "高差")
    private String altitudeDifference;

    @FieldDisplayDefine(value = "运量")
    private String freightVolume;

    @FieldDisplayDefine(value = "运载索", dictCode = "YZS")
    private String carrierLine;

    @FieldDisplayDefine(value = "速度")
    private String speed;

    @FieldDisplayDefine(value = "承载索")
    private String bearingCable;

    @FieldDisplayDefine(value = "索距")
    private String cablePitch;

    @FieldDisplayDefine(value = "张紧油压（重锤重量）")
    private String oilPressureHeavyHammer;

    @FieldDisplayDefine(value = "运载工具数量和类型")
    private String numberAndTypeOfVehicles;

}
