package com.yeejoin.amos.boot.module.jg.biz.discardOrder.factory;

import com.yeejoin.amos.boot.module.jg.biz.discardOrder.factory.support.DiscardOrderCheck;
import com.yeejoin.amos.boot.module.jg.biz.discardOrder.factory.support.SupportableDiscardOrderCheck;
import com.yeejoin.amos.boot.module.jg.biz.discardOrder.wrapper.DiscardOrderCheckWrapper;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@RequiredArgsConstructor
public class DiscardOrderCheckFactory {

    private final List<SupportableDiscardOrderCheck> discardOrderChecks;

    public DiscardOrderCheck getDiscardOrderCheck(String clazz) {
        for (SupportableDiscardOrderCheck discardOrderCheck : discardOrderChecks) {
            if (discardOrderCheck.support(clazz)) {
                return new DiscardOrderCheckWrapper(discardOrderCheck);
            }
        }
        throw new UnsupportedOperationException("not support discard order check" + "{" + clazz + "}");
    }

}
