package com.yeejoin.amos.boot.module.jg.biz.reminder.biz.editEquip;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.jg.biz.edit.process.equip.CommonEquipDataProcessService;
import com.yeejoin.amos.boot.module.jg.biz.reminder.service.CommonReminderService;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgRegisterInfoServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.IdxBizJgUseInfoServiceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgRegisterInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgUseInfo;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
@RequiredArgsConstructor
@Getter
public class EditEquipParseService {
    private final IdxBizJgUseInfoServiceImpl idxBizJgUseInfoService;

    private final IdxBizJgRegisterInfoServiceImpl idxBizJgRegisterInfoService;

    private final CommonEquipDataProcessService equipDataProcessService;

    private final CommonReminderService reminderService;

    public String getRegTypeForEdit(String record) {
        IdxBizJgUseInfo useInfo = idxBizJgUseInfoService.getOneData(record);
        String dataSource = useInfo.getDataSource();
        if (dataSource.contains("jg_his_black")) {
            return "2";
        } else if (dataSource.contains("jg_his")) {
            return "1";
        } else {
            return "0";
        }
    }

    public String getRegTypeFromJson(String dataSource) {
        if (dataSource.contains("jg_his_black")) {
            return "2";
        } else if (dataSource.contains("jg_his")) {
            return "1";
        } else {
            return "0";
        }
    }


    public Map<String, Object> getEquipDetailByRecord(String record) {
        return equipDataProcessService.getEquipDetailByRecord(record);
    }

    public Boolean getIsRegister(String bizId) {
        IdxBizJgUseInfo useInfo = idxBizJgUseInfoService.getOne(new LambdaQueryWrapper<IdxBizJgUseInfo>().eq(IdxBizJgUseInfo::getRecord, bizId).select(IdxBizJgUseInfo::getRecord, IdxBizJgUseInfo::getIsIntoManagement));
        IdxBizJgRegisterInfo registerInfo = idxBizJgRegisterInfoService.getOne(new LambdaQueryWrapper<IdxBizJgRegisterInfo>().eq(IdxBizJgRegisterInfo::getRecord, bizId).select(IdxBizJgRegisterInfo::getRecord, IdxBizJgRegisterInfo::getUseOrgCode));
        return useInfo.getIsIntoManagement() && StringUtils.isNotEmpty(registerInfo.getUseOrgCode());
    }
}
