package com.yeejoin.amos.boot.module.common.api.interceptor;


import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.*;


import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Properties;

@Component
//	标志该类是一个拦截器
// {@Signature(type = StatementHandler.class, method = "prepare", args = {Connection.class, Integer.class})}
@Intercepts({
        @Signature(type = Executor.class, method = "query", args = {MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}),
        @Signature(type = Executor.class, method = "query", args = {MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}),
}
)
public class PluginInterceptor implements Interceptor {

    /**
     * 进行拦截的时候要执行的方法
     *
     * @param invocation
     * @return
     * @throws Throwable
     */
    public Object intercept(Invocation invocation) throws Throwable {
        System.out.println("====intercept======");

        Object[] args = invocation.getArgs();
        MappedStatement mappedStatement = (MappedStatement) args[0];
        Object parameter = args[1];
        RowBounds rowBounds = (RowBounds) args[2];
        ResultHandler resultHandler = (ResultHandler) args[3];
        Executor executor = (Executor) invocation.getTarget();
        CacheKey cacheKey;
        BoundSql boundSql;

        //由于逻辑关系，只会进入一次
        if (args.length == 4) {
            //4 个参数时
            boundSql = mappedStatement.getBoundSql(parameter);
            cacheKey = executor.createCacheKey(mappedStatement, parameter, rowBounds, boundSql);
        } else {
            //6 个参数时
            cacheKey = (CacheKey) args[4];
            boundSql = (BoundSql) args[5];
        }
        //id为执行的mapper方法的全路径名，如com.metro.dao.UserMapper.insertUser
        String id = mappedStatement.getId();

        //获取到原始sql语句
        String sql = boundSql.getSql();

        if ("com.yeejoin.amos.boot.module.common.api.mapper.OrgUsrMapper.selectPersonListCount".equals(id) ||
                "com.yeejoin.amos.boot.module.common.api.mapper.OrgUsrMapper.selectPersonList".equals(id)) {
            HashMap par = new HashMap();
            if (parameter instanceof HashMap) {
                par = (HashMap) ((HashMap<?, ?>) parameter).get("map");
            }

            LinkedHashMap<String, String> fieldsValue = (LinkedHashMap<String, String>) par.get("fieldsValue");
            Iterator<String> iterator = fieldsValue.keySet().stream().iterator();

            while (iterator.hasNext()) {
                String next = iterator.next();
                sql = sql.replaceFirst("item", next).replaceFirst("ietmValue", new StringBuffer().append("'").append(fieldsValue.get(next)).append("'").toString());
            }

            //通过反射修改sql语句
            Field field = boundSql.getClass().getDeclaredField("sql");
            ReflectionUtils.makeAccessible(field);
            field.set(boundSql, sql);
            return executor.query(mappedStatement, parameter, rowBounds, resultHandler, cacheKey, boundSql);
        } else if ("com.yeejoin.amos.boot.module.common.api.mapper.DynamicFormInstanceMapper.listAll".equals(id) ||
                "com.yeejoin.amos.boot.module.common.api.mapper.DynamicFormInstanceMapper.listOneDayDutyPerson".equals(id) ||
                "com.yeejoin.amos.boot.module.common.api.mapper.DynamicFormInstanceMapper.pageList".equals(id)) {
            HashMap par = new HashMap();
            if (parameter instanceof HashMap) {
                par = (HashMap) ((HashMap<?, ?>) parameter).get("params");
            }

            Iterator<String> iterator = par.keySet().iterator();

            while (iterator.hasNext()) {
                String next = iterator.next();
                sql = sql.replaceFirst("_code", next);
            }

            //通过反射修改sql语句
            Field field = boundSql.getClass().getDeclaredField("sql");
            ReflectionUtils.makeAccessible(field);
            field.set(boundSql, sql);
            return executor.query(mappedStatement, parameter, rowBounds, resultHandler, cacheKey, boundSql);
        } else if ("com.yeejoin.amos.boot.module.common.api.mapper.DynamicFormInstanceMapper.pageListNew".equals(id)) {
            HashMap par = new HashMap();
            HashMap par1 = new HashMap();
            if (parameter instanceof HashMap) {
                par = (HashMap) ((HashMap<?, ?>) parameter).get("params");
                par1 = (HashMap) ((HashMap<?, ?>) parameter).get("fieldCodes");
            }

            Iterator<String> iterator = par.keySet().iterator();

            while (iterator.hasNext()) {
                String next = iterator.next();
                sql = sql.replaceFirst("_code", next);
            }

            Iterator<String> iterator1 = par1.keySet().iterator();

            while (iterator1.hasNext()) {
                String next = iterator1.next();
                sql = sql.replaceFirst("_keyName", next);
            }

            //通过反射修改sql语句
            Field field = boundSql.getClass().getDeclaredField("sql");
            ReflectionUtils.makeAccessible(field);
            field.set(boundSql, sql);
            return executor.query(mappedStatement, parameter, rowBounds, resultHandler, cacheKey, boundSql);
        } else {
            return invocation.proceed();
        }
    }

    public Object plugin(Object target) {
        System.out.println("-----------------------------plugin-------------------------");
        return Plugin.wrap(target, this);
    }

    public void setProperties(Properties properties) {
        System.out.println("====setProperties======");
    }

}