package com.yeejoin.amos.supervision.common.enums;

/**
 * 计划频次类型枚举
 */
public enum PlanFrequencyEnum {

    NUM("次", "0", "次检查报告"),
    WEEK("周", "2", "周检查报告"),
    MONTH("月", "3", "月检查报告"),
    QUARTER("季度", "4", "季度检查报告");

    String name;

    String code;

    String reportName;

    PlanFrequencyEnum(String name, String code, String reportName) {
        this.name = name;
        this.code = code;
        this.reportName = reportName;
    }

    public static PlanFrequencyEnum getEnumByCode(String code) {
        for (PlanFrequencyEnum c : PlanFrequencyEnum.values()) {
            if (c.getCode().equals(code)) {
                return c;
            }
        }
        return null;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getExtraInfo() {
        return reportName;
    }

    public void setExtraInfo(String reportName) {
        this.reportName = reportName;
    }
}
