package com.yeejoin.equipmanage.controller;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.equipmanage.common.dto.FileManageDto;
import com.yeejoin.equipmanage.common.entity.FileManage;
import com.yeejoin.equipmanage.common.utils.CommonPageInfoParam;
import com.yeejoin.equipmanage.common.utils.CommonPageParamUtil;
import com.yeejoin.equipmanage.common.utils.CommonResponseUtil;
import com.yeejoin.equipmanage.config.PersonIdentify;
import com.yeejoin.equipmanage.service.FileManageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Date;
import java.util.Map;

@RestController
@Api(tags = "卡片 - 项目管理管理")
@RequestMapping(value = "/cardFileManage", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
public class FileManageController extends BaseController {


    @Autowired
    private FileManageService fileManageService;

    @PersonIdentify
    @RequestMapping(value = "/saveFileManage", method = RequestMethod.POST)
    @TycloudOperation(ApiLevel = UserType.AGENCY, needAuth = false)
    @ApiOperation(httpMethod = "POST", value = "添加", produces = "application/json;charset=UTF-8", notes = "添加")
    public ResponseModel saveFileManage(@RequestBody FileManageDto dto) {
        ReginParams reginParams = getSelectedOrgInfo();
        dto.setBizOrgCode(reginParams.getPersonIdentity().getBizOrgCode());
        fileManageService.saveFileManage(dto);
        return CommonResponseUtil.success();
    }

    @PersonIdentify
    @RequestMapping(value = "/getFileManageByPage", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表查询", produces = "application/json;charset=UTF-8", notes = "列表查询")
    public ResponseModel<Map<String, Object>> getFileManageByPage(FileManageDto dto) {
        ReginParams reginParams = getSelectedOrgInfo();
        dto.setBizOrgCode(reginParams.getPersonIdentity().getBizOrgCode());
        return CommonResponseUtil.success(fileManageService.getFileManageByPage(dto));
    }

    @PersonIdentify
    @RequestMapping(value = "/getFileManageByName", method = RequestMethod.GET)
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "列表行点击查看按钮", produces = "application/json;charset=UTF-8", notes = "列表行点击查看按钮")
    public ResponseModel<Page<Map<String, Object>>> getFileManageByName(FileManageDto dto) {
        ReginParams reginParams = getSelectedOrgInfo();
        dto.setBizOrgCode(reginParams.getPersonIdentity().getBizOrgCode());
        return CommonResponseUtil.success(fileManageService.getFileManageByName(dto));
    }
}
