package com.yeejoin.amos.patrol.business.dao.mapper;

import com.yeejoin.amos.patrol.business.entity.mybatis.CheckChkExListBo;
import com.yeejoin.amos.patrol.business.entity.mybatis.PlanTaskPointInputItemBo;
import com.yeejoin.amos.patrol.business.entity.mybatis.PointCheckDetailBo;
import com.yeejoin.amos.patrol.business.param.CheckPtListPageParam;
import com.yeejoin.amos.patrol.business.param.PlanTaskPageParam;
import com.yeejoin.amos.patrol.business.vo.CodeOrderVo;
import com.yeejoin.amos.patrol.business.vo.LeavePlanTaskVo;
import com.yeejoin.amos.patrol.business.vo.PlanTaskVo;
import com.yeejoin.amos.patrol.dao.entity.Plan;
import com.yeejoin.amos.patrol.dao.entity.PlanTask;
import com.yeejoin.amos.patrol.dao.entity.PointInputItem;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface PlanTaskMapper extends BaseMapper {
	/**
	 * 统计-计划执行
	 * @param params
	 * @return
	 */
	long countPlanTask(PlanTaskPageParam params);
   /**
    * 计划执行查询
    * @param params
    * @return
    */
	List<HashMap<String, Object>> getPlanTaskInfo(PlanTaskPageParam params);
	/**
	 * 批量删除
	 * @param strArry
	 */
	void planTaskDet(String[] strArry);

	/**
	 * 更新任务表
	 * @param param
	 */
	void updatePlanTaskPtInfo(HashMap<String, Object> param);

	/**
	 * 查询需删除的任务信息列表
	 * @param param
	 * @return
	 */
	List<Long> getGenPlanTask(HashMap<String, Object> param);

	/**
	 * 根据路线id获取关联的计划任务
	 *
	 * @param routeId
	 * @return
	 */
	List<PlanTask> getPlanTaskByRouteId(@Param(value = "routeId") Long routeId);
	/**
	 * 根据巡检点id获取关联的计划任务
	 *
	 * @param routeId
	 * @return
	 */
	List<HashMap<String, Object>> getPlanTaskByPointId(HashMap<String, Object> param);
	/**
	 * 	根据条件查询计划任务列表
	 * @param params
	 * @return
	 */
	List<Map<String, Object>> getPlanTasks(HashMap<String, Object> params);



	@Select("SELECT\n" +
			"\t\t\ta.planTaskId,\n" +
			"\t\t\ta.OrgCode,\n" +
			"\t\t\ta.taskName,\n" +
			"\t\t\ta.userId,\n" +
			"\t\t\ta.beginTime,\n" +
			"\t\t\ta.endTime,\n" +
			"\t\t\ta.checkDate,\n" +
			"\t\t\ta.finshNum,\n" +
			"\t\t\ta.taskPlanNum,\n" +
			"\t\t\ta.finishStatus,\n" +
			"\t\t\ta.batchNo,\n" +
			"\t\t\ta.userId  executiveName,\n" +
			"\t\t\ta.userName,\n" +
			"\t\t\ta.userDept\n" +
			"\t\tFROM\n" +
			"\t\t\t(\n" +
			"\t\t\t\tSELECT\n" +
			"\t\t\t\t\tpt.id planTaskId,\n" +
			"\t\t\t\t\tpt.org_code OrgCode,\n" +
			"\t\t\t\t\tp. NAME taskName,\n" +
			"\t\t\t\t\tpt. STATUS,\n" +
			"\t\t\t\t\tpt.user_id userId,\n" +
			"\t\t\t\t\tdate_format(\n" +
			"\t\t\t\t\t\tpt.begin_time,\n" +
			"\t\t\t\t\t\t'%Y-%m-%d %H:%i:%s'\n" +
			"\t\t\t\t\t) beginTime,\n" +
			"\t\t\t\t\tdate_format(\n" +
			"\t\t\t\t\t\tpt.end_time,\n" +
			"\t\t\t\t\t\t'%Y-%m-%d %H:%i:%s'\n" +
			"\t\t\t\t\t) endTime,\n" +
			"\t\t\t\t\tdate_format(\n" +
			"\t\t\t\t\t\tpt.check_date,\n" +
			"\t\t\t\t\t\t'%Y-%m-%d %H:%i:%s'\n" +
			"\t\t\t\t\t)checkDate,\n" +
			"\t\t\t\t\tpt.finish_num finishNum,\n" +
			"\t\t\t\t\tpt.finish_status finishStatus,\n" +
			"\t\t\t\t\tpt.id batchNo,\n" +
			"\t\t\t\t\tpt.route_id,\n" +
			"\t\t\t\t\tpt.point_num taskPlanNum,\n" +
			"\t\t\t\t\tpt.finish_num finshNum,\n" +
			"\t\t\t\t\tpt.user_name userName,\n" +
			"\t\t\t\t\tpt.user_dept userDept\n" +
			"\t\t\t\tFROM\n" +
			"\t\t\t\tp_plan_task pt\n" +
			"\t\t\t\tINNER JOIN  p_plan p ON pt.plan_id = p.id\n" +
			"\t\t\t) a\n" +
			"<where>\n" +
			"\t\t\t<if test=\"userId != null and userId > 0 \"> and find_in_set(#{userId},a.userId)>0</if>\n" +
			"\t\t\t<if test=\"routeId != null and routeId > 0 \"> and a.route_id = #{routeId} </if>\n" +
			"\t\t\t<if test=\"checkDate != null and checkDate != '' \"> and a.beginTime <![CDATA[<=]]> #{checkDate} and a.endTime <![CDATA[>=]]> #{checkDate} </if>\n" +
			"\t\t\t<if test=\"finishStatus != null\"> and a.finishStatus = #{finishStatus}</if>\n" +
			"\t\t\t<if test=\"orgCode != null and orgCode !=''\" > and a.OrgCode LIKE CONCAT( #{orgCode}, '%' ) </if>\n" +
			"\t\t\t<if test=\"startTime != null and startTime != '' and endTime != null and endTime != ''  \">\n" +
			"\t\t\t\tAND (\n" +
			"\t\t\t\t(\n" +
			"\t\t\t\ta.beginTime <![CDATA[>=]]>  #{startTime}\n" +
			"\t\t\t\tAND a.endTime <![CDATA[<=]]> #{endTime}\n" +
			"\t\t\t\t)\n" +
			"\t\t\t\tOR (\n" +
			"\t\t\t\ta.beginTime <![CDATA[<=]]> #{endTime}\n" +
			"\t\t\t\tAND a.endTime <![CDATA[>=]]> #{endTime}\n" +
			"\t\t\t\t)\n" +
			"\t\t\t\tOR (\n" +
			"\t\t\t\ta.beginTime <![CDATA[<=]]> #{startTime}\n" +
			"\t\t\t\tAND a.endTime <![CDATA[>]]> #{startTime}\n" +
			"\t\t\t\t)\n" +
			"\t\t\t\tOR (\n" +
			"\t\t\t\ta.beginTime <![CDATA[<=]]> #{startTime}\n" +
			"\t\t\t\tAND a.endTime <![CDATA[>=]]> #{endTime}\n" +
			"\t\t\t\t)\n" +
			"\t\t\t\t)\n" +
			"\t\t\t</if>\n" +
			"\t\t\t<if test=\"query != null and query != '' \">\n" +
			"\t\t\t\t<if test=\"queryType != null and queryType != 'executiveName' and queryType != 'plan' \">\n" +
			"\t\t\t\t\tAND EXISTS (\n" +
			"\t\t\t\t\tSELECT\n" +
			"\t\t\t\t\t1\n" +
			"\t\t\t\t\tFROM\n" +
			"\t\t\t\t\tp_point pp\n" +
			"\t\t\t\t\tLEFT JOIN p_route_point rp ON rp.point_id = pp.id\n" +
			"\t\t\t\t\tLEFT JOIN p_route r ON r.id = rp.route_id\n" +
			"\t\t\t\t\twhere a.route_id = r.id\n" +
			"\t\t\t\t\t<if test=\"queryType == null or queryType == '' or queryType == 'all' \">\n" +
			"\t\t\t\t\t\tAND CONCAT(pp.name, ',',r.name, ',', pp.point_no,a.taskName, ',', a.batchNo) LIKE concat('%', #{query}, '%')\n" +
			"\t\t\t\t\t</if>\n" +
			"\t\t\t\t\t<if test=\"queryType != null and queryType == 'route' \">\n" +
			"\t\t\t\t\t\tAND r.name LIKE concat('%', #{query}, '%')\n" +
			"\t\t\t\t\t</if>\n" +
			"\t\t\t\t\t<if test=\"queryType != null and queryType == 'point' \">\n" +
			"\t\t\t\t\t\tAND CONCAT(pp.name, ',', pp.point_no) LIKE concat('%', #{query}, '%')\n" +
			"\t\t\t\t\t</if>\n" +
			"\t\t\t\t\t)\n" +
			"\t\t\t\t</if>\n" +
			"\t\t\t\t<if test=\"queryType != null and queryType == 'executiveName' \">\n" +
			"\t\t\t\t\tAND a.userName  LIKE concat('%',  #{query}, '%')\n" +
			"\t\t\t\t</if>\n" +
			"\t\t\t\t<if test=\"queryType != null and queryType == 'plan' \">\n" +
			"\t\t\t\t\tAND CONCAT(a.taskName, ',', a.batchNo) LIKE concat('%', #{query}, '%')\n" +
			"\t\t\t\t</if>\n" +
			"\t\t\t</if>\n" +
			"\t\t</where>\n" +
			"\t\t<if test=\"orderBy != null and orderBy != ''\"> order by #{orderBy} </if>\n" +
			"\t\tlimit #{offset},#{pageSize}")
	List<Map<String, Object>> getPlanTaskNew(HashMap<String, Object> params);

	/**
	 *	 通过计划任务Id获得计划任务信息
	 * @param planTaskId
	 * @return
	 */
	Map queryPlanTaskById(@Param(value="planTaskId") Long planTaskId);
	/**
	 * 	通过计划任务Id获取任务所有点信息
	 * @param planTaskId
	 * @return
	 */
	List getPlanTaskPoints(@Param(value="planTaskId") Long planTaskId);
	/**
	 * 	获取用户当前所有可以做的任务个数
	 * @param userId
	 * @return
	 */
	int getCurrentPlanTaskCount(@Param(value="userId") String userId);

	/**
	 * 根据计划任务id获取所有巡检项信息
	 * @param planTaskId
	 * @return
	 */
	List<PlanTaskPointInputItemBo> getPlanTaskPointInputItemByPlanTaskId(@Param(value="planTaskId") Long planTaskId,@Param(value="planTaskDetailStatus") String planTaskDetailStatus);

	/**
	 * 条件查询数据
	 * @param param
	 * @return
	 */
	List<PlanTaskVo> getPlanTaskInfoList(PlanTaskPageParam param);
	/**
	 * 根据ids获取执行计划
	 * @param ids
	 * @return
	 */
	List<PlanTaskVo> getPlanTaskListByIds(@Param("ids") Long[] ids);
	/**
	 * 分页统计
	 * @param param
	 * @return
	 */
	long countChkExListData(CheckPtListPageParam param);
	long countChkExListDataNew(CheckPtListPageParam param);

	/**
	 * 今日执行情况，业务信息查询
	 * @param param
	 * @return
	 */
	List<CheckChkExListBo> getChkExList(CheckPtListPageParam param);
	List<CheckChkExListBo> getChkExListNew(CheckPtListPageParam param);
	/**
	 * 任务分页查询数量
	 * @param params 参数
	 * @return long
	 */
	long getPlanTasksCount(HashMap<String, Object> params);

	Map<String, Object> getPlanTaskStatisticsForApp(HashMap<String, Object> params);


	/**
	 * 根据计划id和点id获取点详情
	 * @param planTaskId
	 * @param pointId
	 * @return
	 */
	PointCheckDetailBo getPointPlanTaskInfo(@Param("planTaskId") Long planTaskId,@Param("pointId") Long pointId);

	/**
	 * 根据路线id和点id获取该点的检查项
	 * @param routeId
	 * @param pointId
	 * @return
	 */
	List<PointCheckDetailBo> getPointInputByRouteIdAndPointId(@Param("routeId") Long routeId,@Param("pointId") Long pointId);
	/**
	 *	 统计当日任务累计完成情况
	 * @param loginOrgCode
	 * @return
	 */
	String getCumulativePlanCountByOrgCode(@Param("orgCode") String loginOrgCode);
	/**
	 * 获取用户离线巡检计划任务信息
	 * @param params
	 * @return
	 */
	List<LeavePlanTaskVo> queryLeavePlanTask(HashMap<String, Object> params);

	/**
	 * 根据路线id与点id，获取路线点项
	 *
	 * @param routeId
	 * @param pointId
	 * @return
	 */
	List<PointInputItem> getRoutePointInputItem(@Param(value="routeId") long routeId, @Param(value="pointId") long pointId);


	List<CodeOrderVo> queryCodeOrderVo(HashMap<String, Object> params);
	/**
	 * 重新统计用户重做日期段内计划任务
	 * @param userId
	 * @param refDate
	 * @param orgCode
	 */
	void reformStatistics(@Param(value="userId") String userId, @Param(value="refDate") String refDate, @Param(value="orgCode")String orgCode);

	List<Map<String, Object>> countFinishByPlanIds(List<Long> planIds);

	List<Map<String, Object>> queryPlanTaskTimeAxis(HashMap<String, Object> params);

	List<Map<String, Object>> queryTimeAxis(HashMap<String, Object> params);

	List<Plan> getPlanIdsByDate(@Param("date") Date date);

	List<PlanTask> getPlanTaskList(@Param("date") Date date);

	/**
	 * 消防巡检信息统计
	 * @param bizOrgCode 业务公司编码
	 * @return 消防巡检信息统计
	 */
    List<Map<String, Object>> firePatrolStatics(@Param("bizOrgCode") String bizOrgCode);

	long countData(@Param(value="param") PlanTaskPageParam param);

	List<HashMap<String, Object>> planTaskPage(@Param(value="param") PlanTaskPageParam param);

	Map<String, Object> getPlanTaskBasicInfo(@Param(value="taskDetailId") String taskDetailId);

	Map<String, Object> getPlanTaskExecuteInfo(@Param(value="taskDetailId") String taskDetailId);

	List<String> getDefinitionObjCode(@Param(value="taskDetailId") String taskDetailId);

	Map<String, Object> getDefectEquipInfo(@Param(value="id") String id);

	List<Map<String, Object>> getCheckMissedEquipInfo(@Param(value="taskDetailId") String taskDetailId);

	List<Map<String, Object>> getCheckQualifiedEquipInfo(@Param(value="taskDetailId") String taskDetailId);

	List<Map<String, Object>> getCheckNotQualifiedEquipInfo(@Param(value="taskDetailId") String taskDetailId);

	String getCheckIdByDetailId(@Param(value="taskDetailId") String taskDetailId);

	String queryByCompanyCode(@Param("companyCode") String companyCode);

	List<Map<String, Object>> getStatics(@Param("bizOrgCode") String bizOrgCode);

	Map<String, Object> queryPatrolInfoList(@Param(value="bizOrgCode") String bizOrgCode, @Param(value="startDate") Date startDate, @Param(value="endDate") Date endDate);

	Map<String, Object> queryPatrolEquipInfo(@Param(value="bizOrgCode") String bizOrgCode, @Param(value="startDate") Date startDate, @Param(value="endDate") Date endDate);

	List<Map<String, Object>> queryPatrolInfo(@Param(value="bizOrgCode") String bizOrgCode, @Param(value="startDate") Date startDate, @Param(value="endDate") Date endDate);
}
