package com.yeejoin;

import com.yeejoin.amos.boot.biz.common.utils.oConvertUtils;
import com.yeejoin.equipmanage.listener.CarIotListener;
import com.yeejoin.equipmanage.listener.CarIotNewListener;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.client.RestTemplate;
import org.typroject.tyboot.component.emq.EmqKeeper;
import org.typroject.tyboot.core.restful.exception.GlobalExceptionHandler;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.Collections;

@SpringBootApplication
@EnableTransactionManagement
@EnableConfigurationProperties
@EnableDiscoveryClient
@MapperScan({ "org.typroject.tyboot.demo.face.orm.dao*", "org.typroject.tyboot.face.*.orm.dao*",
		"org.typroject.tyboot.core.auth.face.orm.dao*", "org.typroject.tyboot.component.*.face.orm.dao*",
		"com.yeejoin.amos.boot.module.*.api.mapper", "com.yeejoin.amos.boot.biz.common.dao.mapper",
		"com.yeejoin.equipmanage.mapper"})
@ComponentScan(value = {"org.typroject", "com.yeejoin.amos", "com.yeejoin.equipmanage"}, excludeFilters = {
		@ComponentScan.Filter(type = FilterType.ASSIGNABLE_TYPE, classes = {org.typroject.tyboot.core.restful.exception.GlobalExceptionHandler.class})})
@EnableFeignClients
@EnableAsync(proxyTargetClass = true)
public class AmostEquipApplication {

	private static final Logger logger = LoggerFactory.getLogger(AmostEquipApplication.class);
	//是否走江西电建的车辆监听器，默认不走，如果在配置文件中添加了该配置且配置的值不为false
	@Value("${jxiop.carIotNewListener.enable:false}")
	private String jxiop;

	@Autowired
	private EmqKeeper emqKeeper;

	@Autowired
	private CarIotListener carIotListener;

	@Autowired
	private CarIotNewListener carIotNewListener;

	public static void main(String[] args) throws UnknownHostException {
		SpringApplication application = new SpringApplication(AmostEquipApplication.class);
		ConfigurableEnvironment environment = new StandardEnvironment();
		int randomClientId = new SecureRandom().nextInt(65536 - 1024) + 1024;
		environment.getPropertySources().addFirst(new MapPropertySource("securityRandomSource",
				Collections.singletonMap("security-random-int", randomClientId)));
		application.setEnvironment(environment);
		application.run();
		String appName = environment.getProperty("spring.application.name");
		GlobalExceptionHandler.setAlwaysOk(true);
		logger.info(
				"\n----------------------------------------------------------\n\t"
						+ "Application {} is running!\n"
						+ "----------------------------------------------------------\n"
				, appName
		);
	}

	@Bean
	@LoadBalanced
	RestTemplate restTemplate(){
		return new RestTemplate();
	}

	/**
	 * 初始化MQTT
	 *
	 * @throws MqttException
	 */
	@Bean
	void initMqtt() throws MqttException {
		try {
			if(jxiop.equals("false")){
				emqKeeper.subscript("+/+/property", 1, carIotListener);
			}else {
				emqKeeper.subscript("+/+/property", 1, carIotNewListener);
			}

		} catch (Exception e) {
			e.printStackTrace();
			logger.error("EMQ初始化连接失败!");
		}
	}

}
