DROP TABLE IF EXISTS `s_company`;
CREATE TABLE `s_company` (
  `id` bigint(20) NOT NULL,
  `company_level` varchar(510) DEFAULT NULL,
  `company_name` varchar(510) DEFAULT NULL,
  `description` varchar(510) DEFAULT NULL,
  `comp_code` varchar(50) DEFAULT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `contact` varchar(20) DEFAULT NULL,
  `latitude` double DEFAULT NULL,
  `longitude` double DEFAULT NULL,
  `address` varchar(100) DEFAULT NULL,
  `telephone` varchar(20) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `site_id` bigint(20) DEFAULT NULL,
  `level` bigint(20) DEFAULT NULL,
  `register_type_id` bigint(20) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `create_user` varchar(512) DEFAULT NULL COMMENT '创建用户',
  `update_user` varchar(512) DEFAULT NULL COMMENT '更新用户',
  `is_delete` bit(1) NOT NULL COMMENT '是否删除：0表示未删除，1表示已删除',
  PRIMARY KEY (`id`),
  UNIQUE KEY `comp_code` (`comp_code`) USING BTREE,
  UNIQUE KEY `comp_code_2` (`comp_code`) USING BTREE,
  KEY `FK__s_company__s_site_id__38495279` (`site_id`) USING BTREE
) ENGINE=FEDERATED DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `s_department`;
CREATE TABLE `s_department` (
  `id` bigint(20) NOT NULL,
  `department_name` varchar(510) DEFAULT NULL,
  `description` varchar(510) DEFAULT NULL,
  `company_id` bigint(20) DEFAULT NULL,
  `depm_code` varchar(50) DEFAULT NULL,
  `parent_id` bigint(20) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `create_user` varchar(512) DEFAULT NULL COMMENT '创建用户',
  `update_user` varchar(512) DEFAULT NULL COMMENT '更新用户',
  `is_delete` bit(1) NOT NULL COMMENT '是否删除：0表示未删除，1表示已删除',
  PRIMARY KEY (`id`),
  KEY `FK__s_departm__compa__74794A92` (`company_id`) USING BTREE
) ENGINE=FEDERATED DEFAULT CHARSET=utf8;

DROP TABLE IF EXISTS `s_user`;
CREATE TABLE `s_user` (
  `id` bigint(20) NOT NULL,
  `deletable` bit(1) DEFAULT NULL,
  `email` varchar(510) DEFAULT NULL,
  `enabled` bit(1) DEFAULT NULL,
  `identification_id` varchar(255) DEFAULT NULL,
  `is_online` bit(1) DEFAULT NULL,
  `mobile` varchar(510) DEFAULT NULL,
  `name` varchar(510) DEFAULT NULL,
  `password` varchar(510) DEFAULT NULL,
  `user_name` varchar(510) DEFAULT NULL,
  `department_id` bigint(20) DEFAULT NULL,
  `role_id` bigint(20) DEFAULT NULL,
  `telephone` varchar(510) DEFAULT NULL,
  `company_id` bigint(20) DEFAULT NULL,
  `org_code` varchar(50) DEFAULT NULL,
  `remark_1` varchar(255) DEFAULT NULL,
  `remark_2` varchar(255) DEFAULT NULL,
  `register_code` varchar(255) DEFAULT NULL,
  `create_date` datetime DEFAULT NULL COMMENT '创建时间',
  `update_date` datetime DEFAULT NULL COMMENT '更新时间',
  `create_user` varchar(512) DEFAULT NULL COMMENT '创建用户',
  `update_user` varchar(512) DEFAULT NULL COMMENT '更新用户',
  `is_delete` bit(1) NOT NULL COMMENT '是否删除：0表示未删除，1表示已删除',
  PRIMARY KEY (`id`),
  KEY `FK__s_user__departme__7D0E9093` (`department_id`) USING BTREE,
  KEY `FK__s_user__role_id__7E02B4CC` (`role_id`) USING BTREE,
  KEY `FK__s_user__company___7C1A6C5A` (`company_id`) USING BTREE
) ENGINE=FEDERATED DEFAULT CHARSET=utf8;


