package com.yeejoin.precontrol.common.service;

import com.yeejoin.precontrol.common.entity.AppMenuConfig;
import com.yeejoin.precontrol.common.param.MobileLoginParam;
import com.yeejoin.precontrol.common.vo.UserRegistrationVo;

import java.util.List;
import java.util.Map;

/**
 * @author DELL
 */
public interface ISafetyService {
    /**
     * app 登陆
     *
     * @param param MobileLoginParam.class
     * @return Map<String, Object>
     */
    Map<String, Object> loginFromApp(MobileLoginParam param);

    /**
     * 注册
     *
     * @param vo UserRegistrationVo.class
     * @return 是否成功
     */
    Boolean registerFromApp(UserRegistrationVo vo);

    /**
     * 查询注册历史
     *
     * @param phoneNo 手机号
     * @return 是否成功
     */
    UserRegistrationVo getRegisterHistory(String phoneNo);
    /**
     * 获取验证码
     * @param phoneNo 手机号
     */
    //void getAuthCode(String phoneNo);

    /**
     * 获取验证码
     *
     * @param phoneNo 手机号
     */
    void getAuthCode(String phoneNo);

    /**
     * 查询用户有的功能菜单
     *
     * @param userId 用户id
     * @return List
     */
    List permissionMenuList(String userId);

    /**
     * 查询所有菜单
     *
     * @param userId 用户id
     * @return List
     */
    List allPermissionMenuList(String userId);

    /**
     * 角色保存
     *
     * @param userId 用户id
     * @param list   菜单集合
     */
    Boolean savePermission(String userId, List<AppMenuConfig> list);
}
