package com.yeejoin.amos.boot.module.elevator.api.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.module.elevator.api.dto.RescueStationDto;
import com.yeejoin.amos.boot.module.elevator.api.entity.RescueStation;

import java.util.List;

/**
 * 服务类
 *
 * @author tb
 * @date 2021-06-01
 */
public interface IRescueStationService extends IService<RescueStation> {

    /**
     * 根据经纬度和距离反馈救援机构列表
     *
     * @param lat
     * @param lon
     * @param distance 单位为千米
     * @return
     */
    List<RescueStationDto> getListByLatLonDistance(String lat, String lon, Integer distance);

    List<RescueStationDto> selectExportData(String exportId);

    IPage<RescueStation> getRescueStationList(IPage<RescueStation> page, RescueStationDto rescueStationDto);
}
