package com.yeejoin.amos;

import com.yeejoin.amos.boot.biz.common.utils.oConvertUtils;
import com.yeejoin.amos.boot.module.elevator.biz.service.impl.StartPlatformTokenService;
import net.javacrumbs.shedlock.spring.annotation.EnableSchedulerLock;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.eureka.EnableEurekaClient;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;

import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * <pre>
 * 特种设备服务启动类
 * </pre>
 *
 * @author DELL
 */
@SpringBootApplication
@EnableTransactionManagement
@EnableConfigurationProperties
@ServletComponentScan
@EnableDiscoveryClient
@EnableFeignClients
@EnableAsync
@EnableSwagger2WebMvc
@EnableEurekaClient
@EnableSchedulerLock(defaultLockAtMostFor = "10m")
//@EnableScheduling
@MapperScan({"org.typroject.tyboot.demo.face.orm.dao*", "org.typroject.tyboot.face.*.orm.dao*",
        "org.typroject.tyboot.core.auth.face.orm.dao*", "org.typroject.tyboot.component.*.face.orm.dao*",
        "com.yeejoin.amos.boot.module.**.api.mapper", "com.yeejoin.amos.boot.biz.common.dao.mapper"})
@ComponentScan(basePackages = {"org.typroject", "com.yeejoin.amos"})
public class Amos96333Application {
    private static final Logger logger = LoggerFactory.getLogger(Amos96333Application.class);

    @Autowired
    private StartPlatformTokenService startPlatformTokenService;


    public static void main(String[] args) throws UnknownHostException {
        ConfigurableApplicationContext context = SpringApplication.run(Amos96333Application.class, args);
        Environment env = context.getEnvironment();
        String ip = InetAddress.getLocalHost().getHostAddress();
        String port = env.getProperty("server.port");
        String path = oConvertUtils.getString(env.getProperty("server.servlet.context-path"));
        logger.info("\n----------------------------------------------------------\n\t"
                + "Application Amos-Biz-Boot is running! Access URLs:\n\t" + "Swagger文档: \thttp://" + ip + ":" + port
                + path + "/doc.html\n" + "----------------------------------------------------------");
    }

    @Bean
    public void initToken() {
        startPlatformTokenService.getToken();
    }
}
