package com.yeejoin.amos.boot.module.jg.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.jg.api.common.BizCustomDateSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 维修告知
 *
 * @author system_generator
 * @date 2023-12-19
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "JgMaintainNoticeDto", description = "维修告知")
public class JgMaintainNoticeDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "申请编号")
    private String applyNo;

    @ApiModelProperty(value = "告知日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date noticeDate;

    @ApiModelProperty(value = "告知状态")
    private String noticeStatus;

    @ApiModelProperty(value = "告知状态名称")
    private String noticeStatusDesc;

    @ApiModelProperty(value = "施工单位统一信用代码")
    private String installUnitCreditCode;

    @ApiModelProperty(value = "施工单位名称")
    private String installUnitName;

    @ApiModelProperty(value = "设备数量")
    private Integer equipNum;

    @ApiModelProperty(value = "流程实例id")
    private String instanceId;

    @ApiModelProperty(value = "下步执行角色/人id")
    private String nextExecutorIds;

    @ApiModelProperty(value = "流程执行顺序标识")
    private String executeSequence;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date createDate;

    @ApiModelProperty(value = "创建人id ")
    private String createUserId;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "流程状态")
    private String instanceStatus;

    @ApiModelProperty(value = "受理完成日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date acceptDate;

    @ApiModelProperty(value = "施工区域-省")
    private String province;

    @ApiModelProperty(value = "施工区域-市")
    private String city;

    @ApiModelProperty(value = "施工区域-区/县")
    private String county;

    @ApiModelProperty(value = "施工区域-街道（镇）")
    private String street;

    @ApiModelProperty(value = "施工设备详细地址")
    private String address;

    @ApiModelProperty(value = "计划施工日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date planDate;

    @ApiModelProperty(value = "接收机构单位代码")
    private String receiveCompanyCode;

    @ApiModelProperty(value = "接收机构")
    private String receiveOrgName;

    @ApiModelProperty(value = "施工负责人")
    private String constructionManager;

    @ApiModelProperty(value = "施工负责人id")
    private String constructionManagerId;

    @ApiModelProperty(value = "施工负责人手机")
    private String constructionManagerPhone;

    @ApiModelProperty(value = "检验单位统一信用代码")
    private String inspectionUnitCreditCode;

    @ApiModelProperty(value = "检验单位名称")
    private String inspectionUnitName;

    @ApiModelProperty(value = "委托单位统一信用代码")
    private String entrustingUnitCreditCode;

    @ApiModelProperty(value = "委托单位名称")
    private String entrustingUnitName;

    @ApiModelProperty(value = "委托书附件")
    private String powerOfAttorney;

    @ApiModelProperty(value = "施工合同附件")
    private String constructionContract;

    @ApiModelProperty(value = "委托书附件")
    private List<Map<String, Object>> powerOfAttorneyList;

    @ApiModelProperty(value = "施工合同附件")
    private List<Map<String, Object>> constructionContractList;

    @ApiModelProperty(value = "施工合同是否本单位与甲方直接签署")
    private String isSignedWithA;

    @ApiModelProperty(value = "使用单位统一信用代码")
    private String useUnitCreditCode;

    @ApiModelProperty(value = "使用单位名称")
    private String useUnitName;

    @ApiModelProperty(value = "维修类型（1一般维修，2重点维修）")
    private String maintainType;

    @ApiModelProperty(value = "维修类型（1一般维修，2重点维修）")
    private String maintainTypeDesc;

    @ApiModelProperty(value = "是否已报检")
    private String isInspected;

    @ApiModelProperty(value = "接收机构机构代码")
    private String receiveOrgCode;

    @TableField(exist = false)
    @ApiModelProperty(value = "告知设备列表")
    private List<Map<String, Object>> deviceList;

    @ApiModelProperty(value = "设备使用地点-街道（镇）")
    private String factoryUseSiteStreet;

    @ApiModelProperty(value = "完整地址")
    private String fullAddress;
    ;

    @ApiModelProperty(value = "区名字")
    private String countyName;

    @ApiModelProperty(value = "市名字")
    private String cityName;

    @ApiModelProperty(value = "省名字")
    private String provinceName;

    @ApiModelProperty(value = "街道名字")
    private String streetName;

    @ApiModelProperty(value = "告知单PDF URL")
    private String noticeReportUrl;

    @ApiModelProperty(value = "节点执行人")
    private String promoter;

    @ApiModelProperty(value = "设备类别")
    private String equListCode;

    @ApiModelProperty(value = "设备类别名称")
    private String equCategory;

    private List<String> roleIds;

    private String dataType;

    @ApiModelProperty(value = "状态")
    private String status;

    @ApiModelProperty(value = "下一执行节点ids")
    private String nextExecuteIds;
}
