package com.yeejoin.amos.boot.module.jg.api.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.jg.api.dto.JgEquipTransferDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgEquipTransfer;

import java.util.Map;

/**
 * 设备移交接口类
 *
 * @author system_generator
 * @date 2023-12-20
 */
public interface IJgEquipTransferService  extends IService<JgEquipTransfer> {

    /**
     * 分页查询设备移交接口
     *
     * @param page  分页对象
     * @param dto 查询参数
     * @param type  类型：enterprise-企业端、supervision-监管端
     * @return 设备移交分页列表
     */
    Page<JgEquipTransferDto> queryForJgEquipTransferPage(Page<JgEquipTransfer> page, JgEquipTransferDto dto, String type, ReginParams reginParams);

    /**
     * 根据sequenceNbr查询
     *
     * @param sequenceNbr 主键
     * @return 设备移交详情
     */
    Map<String, Object> queryBySequenceNbr(Long sequenceNbr);

    /**
     * 保存设备移交接口
     * @param submitType 按钮类型
     * @param dto dto
     * @param selectedOrgInfo reginParams
     */
    void saveEquipTransfer(String submitType, Map<String, JgEquipTransferDto> dto, ReginParams selectedOrgInfo);
}
