package com.yeejoin.amos.boot.module.jg.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgChangeRegistrationTransferServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.jg.api.dto.JgChangeRegistrationTransferDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 移装变更登记登记
 *
 * @author system_generator
 * @date 2023-12-20
 */
@RestController
@Api(tags = "移装变更登记登记Api")
@RequestMapping(value = "/jg-change-registration-transfer")
public class JgChangeRegistrationTransferController extends BaseController {

    @Autowired
    JgChangeRegistrationTransferServiceImpl jgChangeRegistrationTransferServiceImpl;

    /**
     * 新增移装变更登记登记
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增移装变更登记登记", notes = "新增移装变更登记登记")
	public ResponseModel<JgChangeRegistrationTransferDto> save(@RequestBody JgChangeRegistrationTransferDto model) {
	    model = jgChangeRegistrationTransferServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新移装变更登记登记", notes = "根据sequenceNbr更新移装变更登记登记")
	public ResponseModel<JgChangeRegistrationTransferDto> updateBySequenceNbrJgChangeRegistrationTransfer(@RequestBody JgChangeRegistrationTransferDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(jgChangeRegistrationTransferServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除移装变更登记登记", notes = "根据sequenceNbr删除移装变更登记登记")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(jgChangeRegistrationTransferServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个移装变更登记登记",  notes = "根据sequenceNbr查询单个移装变更登记登记")
	public ResponseModel<JgChangeRegistrationTransferDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(jgChangeRegistrationTransferServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "移装变更登记登记分页查询",  notes = "移装变更登记登记分页查询")
	public ResponseModel<Page<JgChangeRegistrationTransferDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<JgChangeRegistrationTransferDto> page = new Page<JgChangeRegistrationTransferDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(jgChangeRegistrationTransferServiceImpl.queryForJgChangeRegistrationTransferPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "移装变更登记登记列表全部数据查询",   notes = "移装变更登记登记列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<JgChangeRegistrationTransferDto>> selectForList() {
	    return ResponseHelper.buildResponse(jgChangeRegistrationTransferServiceImpl.queryForJgChangeRegistrationTransferList());
	}
}
