package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.map.MapBuilder;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.entity.*;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgEquipTransferEqMapper;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgEquipTransferMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgEquipTransferService;
import com.yeejoin.amos.boot.module.jg.api.dto.JgEquipTransferDto;
import com.yeejoin.amos.boot.module.ymt.api.common.BaseException;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.OtherInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.RegistrationInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.service.ICreateCodeService;
import com.yeejoin.amos.component.feign.model.FeignClientResult;
import com.yeejoin.amos.feign.workflow.Workflow;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowBatchDTO;
import com.yeejoin.amos.feign.workflow.model.ActWorkflowStartDTO;
import com.yeejoin.amos.feign.workflow.model.AjaxResult;
import com.yeejoin.amos.feign.workflow.model.TaskResultDTO;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.text.ParseException;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 设备移交服务实现类
 *
 * @author system_generator
 * @date 2023-12-20
 */
@Slf4j
@Service
public class JgEquipTransferServiceImpl extends BaseService<JgEquipTransferDto,JgEquipTransfer, JgEquipTransferMapper> implements IJgEquipTransferService {

    private static final String EQUIP_TRANSFER_PROCESS_KEY = "equipmentHandover";
    private static final String SUBMIT_TYPE_FLOW = "1";

    @Autowired
    private ICreateCodeService iCreateCodeService;

    @Autowired
    JgEquipTransferEqMapper jgEquipTransferEqMapper;

    @Autowired
    OtherInfoMapper tzsJgOtherInfoMapper;

    @Autowired
    RegistrationInfoMapper tzsJgRegistrationInfoMapper;

    @Autowired
    RedisUtils redisUtils;

    @Transactional(rollbackFor = {Exception.class, BaseException.class})
    public void saveOrUpdateModel(String submitType, JgEquipTransferDto model, ReginParams reginParams) {
        String[] taskName = new String[]{"流程结束"};
        // 字段转换
        convertField(model);
        // 获取告知设备列表
        List<Map<String, Object>> deviceList = model.getDeviceList();
        if (CollectionUtils.isEmpty(deviceList)) {
            return;
        }

        // 获取设备移交顺序号
        List<String> applyNoList = iCreateCodeService.createApplicationFormCode(ApplicationFormTypeEnum.SBYJ.getCode(), deviceList.size());
        if (CollectionUtils.isEmpty(applyNoList)) {
            return;
        }
        ArrayList<String> roleListFirst = new ArrayList<>();
        ArrayList<String> roleListSecond = new ArrayList<>();
        // 判断当前是否为提交
        List<String> instanceIdList = new ArrayList<>();
        if (SUBMIT_TYPE_FLOW.equals(submitType)) {
            // 发起流程
            ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
            List<ActWorkflowStartDTO> list = new ArrayList<>();
            for (int i = 0; i<deviceList.size() ; i++
            ) {
                ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                dto.setProcessDefinitionKey(EQUIP_TRANSFER_PROCESS_KEY);
                dto.setBusinessKey(String.valueOf(i));
                list.add(dto);
            }
            actWorkflowBatchDTO.setProcess(list);

            try {
                FeignClientResult result = Workflow.taskV2Client.startByVariableBatch(actWorkflowBatchDTO);
                List<Object> returnList = (List<Object>) result.getResult();
                for (Object obj :returnList
                ) {
                    JSONObject jsonObject =  JSON.parseObject(JSONObject.toJSONString(obj));
                    String instanceId = jsonObject.getString("id");
                    instanceIdList.add(instanceId);
                    // 查询下节点任务
                    if(returnList.get(0).equals(obj)) {
                        getNext(roleListFirst, instanceId,taskName);
                    }
                    // 推动下一个节点
                    AjaxResult ajaxResult = Workflow.taskClient.getTask(instanceId);
                    JSONObject dataObject = JSON.parseObject(JSON.toJSONString(ajaxResult.get("data")));
                    String taskId = dataObject.getString("id");
                    //组装信息
                    TaskResultDTO dto = new TaskResultDTO();
                    dto.setResultCode("approvalStatus");
                    dto.setTaskId(taskId);
                    dto.setComment("提交流程");
                    HashMap<String, Object> map = new HashMap<>();
                    map.put("approvalStatus", "0");
                    dto.setVariable(map);
                    //执行流程
                    AjaxResult ajaxResult1;
                    try {
                        ajaxResult1 = Workflow.taskClient.completeByTask(taskId, dto);
                        if (ajaxResult1.get("code").equals(200)) {
                            getNext(roleListSecond, instanceId,taskName);
                        } else {
                            log.error("提交失败");
                        }
                    } catch (Exception e) {
                        log.error("提交失败：{}", e.getMessage());
                    }
                }
            } catch (Exception e) {
                log.error("提交失败：{}", e.getMessage());
            }
        }

        List<JgEquipTransfer> list = new ArrayList<>();
        List<JgEquipTransferEq> equipTransferEqList = new ArrayList<>();
        deviceList.forEach(obj -> {
            JgEquipTransferEq jgEquipTransferEq = new JgEquipTransferEq();
            JgEquipTransfer dto = new JgEquipTransfer();
            BeanUtils.copyProperties(model, dto);
            int i = deviceList.indexOf(obj);
            String applyNo = applyNoList.get(i);
            dto.setApplyNo(applyNo);
            dto.setApplyDate(new Date());
            dto.setNextExecuteIds(String.join(",", roleListSecond));
            dto.setInstanceStatus(String.join(",", roleListFirst));
            dto.setPromoter(reginParams.getUserModel().getUserId());
            dto.setApplyStatus(taskName[0]);
            jgEquipTransferEq.setEquId(String.valueOf(obj.get("SEQUENCE_NBR")));
            jgEquipTransferEq.setEquipTransferId(applyNo);
            if (!CollectionUtils.isEmpty(instanceIdList)) {
                dto.setInstanceId(instanceIdList.get(i));
                dto.setApplyStatus(String.valueOf(FlowStatusEnum.TO_BE_PROCESSED.getCode()));
            } else {
                dto.setApplyStatus(String.valueOf(FlowStatusEnum.TO_BE_SUBMITTED.getCode()));
            }
            list.add(dto);
            equipTransferEqList.add(jgEquipTransferEq);
        });

        this.baseMapper.insertBatchSomeColumn(list);

        List<JgEquipTransferEq> jgEquipTransferEqList = equipTransferEqList.stream().map(transferEq -> {
            List<JgEquipTransfer> collect = list.stream().filter(transfer -> transferEq.getEquipTransferId().equals(transfer.getApplyNo())).collect(Collectors.toList());
            Long sequenceNbr = collect.get(0).getSequenceNbr();
            return transferEq.setEquipTransferId(String.valueOf(sequenceNbr));
        }).collect(Collectors.toList());
        jgEquipTransferEqMapper.insertBatchSomeColumn(jgEquipTransferEqList);
    }

    private void convertField(JgEquipTransferDto model) {
        if (null == model)
            return;
        //  分割接收机构
        String installUnitId = model.getInstallUnitCreditCode();
        if (!ObjectUtils.isEmpty(installUnitId)) {
            String[] installUnitIdList = installUnitId.split("_");
            if (installUnitIdList.length > 1) {
                model.setInstallUnitCreditCode(installUnitIdList[0]);
                model.setInstallUnitName(installUnitIdList[1]);
            }
        }
    }

    public Map<String, Object> getNextWorkflowNode(String instanceId) {
        String role = "";
        String taskName = "流程结束";
        ArrayList<String> roleList = new ArrayList<>();
        AjaxResult taskNoAuth = Workflow.taskClient.getTaskNoAuth(instanceId);
        if (!org.springframework.util.ObjectUtils.isEmpty(taskNoAuth.get("data"))) {
            JSONObject nextTask = JSON.parseObject(JSON.toJSONString(taskNoAuth.get("data")));
            String nextTaskId = nextTask.getString("id");
            taskName = nextTask.getString("name");
            AjaxResult taskGroupName = Workflow.taskClient.getTaskGroupName(nextTaskId);
            JSONArray data = JSON.parseArray(JSON.toJSONString(taskGroupName.get("data")));
            for (Object datum : data) {
                if (((Map) datum).containsKey("groupId")) {
                    roleList.add(((Map) datum).get("groupId").toString());
                }
            }
        }
        role = String.join(",", roleList);
        return MapBuilder.<String, Object>create().put("taskName", taskName).put("role", role).build();
    }

    void getNext(ArrayList<String> roleListFirst, String instanceId, String[] taskName) {
        AjaxResult aj = Workflow.taskClient.getTaskNoAuth(instanceId);
        JSONObject taskNoAuth = JSON.parseObject(JSON.toJSONString(aj.get("data")));
        if (!org.springframework.util.ObjectUtils.isEmpty(taskNoAuth)) {
            String nextTaskId = taskNoAuth.getString("id");
            AjaxResult taskGroupName = Workflow.taskClient.getTaskGroupName(nextTaskId);
            taskName[0] = taskNoAuth.getString("name");
            JSONArray data = JSON.parseArray(JSON.toJSONString(taskGroupName.get("data")));
            for (Object datum : data) {
                if (((Map) datum).containsKey("groupId")) {
                    roleListFirst.add(((Map) datum).get("groupId").toString());
                }
            }
        }
    }

    /**
     * 启动工作流
     * @param businessKey businessKey
     * @return s
     * @throws Exception e
     */
    public String startFlow(String businessKey) throws Exception {
        // 重新开启工作流
        ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
        dto.setProcessDefinitionKey(EQUIP_TRANSFER_PROCESS_KEY);
        dto.setBusinessKey(StringUtils.defaultString(businessKey, "1"));

        AjaxResult ajaxResult = Workflow.taskClient.startByVariable(dto);
        if (log.isDebugEnabled()) {
            log.debug("开启工作流结果：{}", ajaxResult);
        }
        if (ajaxResult == null || (ajaxResult.get(AjaxResult.CODE_TAG) != null && !"200".equals(ajaxResult.get(AjaxResult.CODE_TAG).toString()))) {
            throw new BaseException("开启工作流错误");
        }
        return ((Map<?, ?>) ajaxResult.get("data")).get("id").toString();
    }

    @Override
    public Page<JgEquipTransferDto> queryForJgEquipTransferPage(Page<JgEquipTransfer> page, JgEquipTransferDto dto, String type, ReginParams reginParams) {

        Page<JgEquipTransfer> equipTransferPage = this.baseMapper.queryForPage(page, dto, type, reginParams.getCompany().getCompanyCode());

        Page<JgEquipTransferDto> equipTransferDtoPage = new Page<>();
        BeanUtils.copyProperties(equipTransferPage, equipTransferDtoPage, "records");
        List<JgEquipTransferDto> records = equipTransferPage.getRecords().stream().map(transfer -> {
            JgEquipTransferDto equipTransferDto = new JgEquipTransferDto();
            BeanUtils.copyProperties(transfer, equipTransferDto);
            if (Objects.nonNull(transfer.getApplyStatus())) {
                equipTransferDto.setApplyStatusDesc(FlowStatusEnum.getNameByType(Long.valueOf(transfer.getApplyStatus())));
            }
            return equipTransferDto;
        }).collect(java.util.stream.Collectors.toList());
        equipTransferDtoPage.setRecords(records);

        return equipTransferDtoPage;
    }

    @Override
    public Map<String, Object> queryBySequenceNbr(Long sequenceNbr) {
        JgEquipTransfer equipTransfer = this.baseMapper.selectById(sequenceNbr);

        if (Objects.isNull(equipTransfer)) {
            return null;
        }

        Map<String, Object> equipTransferInfo = createEquipTransferInfo(equipTransfer);

        String[] fields = {"productPhoto", "designDoc", "designStandard", "factoryStandard",
                "productQualityYieldProve", "insUseMaintainExplain", "inspectReport",
                "proxyStatementAttachment", "installContractAttachment"};

        List<Map<String, Object>> equipmentInfos = this.baseMapper.queryEquipInformation(sequenceNbr);

        handleJsonArrayFields(equipTransferInfo, fields);
        handleJsonArrayFields(equipmentInfos.get(0), fields);

        Map<String, Object> resultMap = new HashMap<>();
        resultMap.putAll(equipmentInfos.get(0));
        resultMap.putAll(equipTransferInfo);
        return  resultMap;
    }

    @Override
    @Transactional(rollbackFor = {Exception.class, BaseException.class})
    public void saveEquipTransfer(String submitType, Map<String, JgEquipTransferDto> dto, ReginParams selectedOrgInfo) {
        String[] taskName = new String[]{"流程结束"};
    }

    private Map<String, Object> createEquipTransferInfo(JgEquipTransfer equipTransfer) {
        Map<String, Object> equipTransferInfo = new HashMap<>(BeanUtil.beanToMap(equipTransfer));
        equipTransferInfo.put("installUnitCreditCode", equipTransfer.getInstallUnitCreditCode() + "_" + equipTransfer.getInstallUnitName());
        return equipTransferInfo;
    }

    private void handleJsonArrayFields(Map<String, Object> map, String[] fields) {
        for (String field : fields) {
            map.computeIfPresent(field, (key, value) -> JSON.parseArray(value.toString()));
        }
    }

    public void accept(JgEquipTransferDto jgEquipTransferDto, String op) {
        String[] taskName = new String[]{"流程结束"};
        String userId = RequestContext.getExeUserId();
        JgEquipTransfer jgEquipTransfer = this.baseMapper.selectById(jgEquipTransferDto.getSequenceNbr());
        jgEquipTransfer.setProcessAdvice(jgEquipTransferDto.getProcessAdvice());
        // 组装设备注册代码
        StringBuffer stringBuffer = new StringBuffer();
        String ym = null;
        try {
            ym = DateUtils.dateFormat(new Date(), DateUtils.DATE_PATTERN_MM);
        } catch (ParseException e) {
            log.error("日期转换失败：{}", e.getMessage());
        }

        ArrayList<String> roleList = new ArrayList<>();
        boolean submit = submit(jgEquipTransfer, op);

        if(submit) {
            getNext(roleList, jgEquipTransferDto.getInstanceId(),taskName);
            jgEquipTransfer.setApplyStatus(taskName[0]);
            if("0".equals(op)) {
                if(roleList.isEmpty()) {
                    jgEquipTransfer.setApplyStatus(String.valueOf(FlowStatusEnum.TO_BE_FINISHED.getCode()));
                    jgEquipTransfer.setPromoter("");
                } else {
                    jgEquipTransfer.setNextExecuteIds(String.join(",", roleList));
                    if (!ObjectUtils.isEmpty(jgEquipTransfer.getInstanceStatus())) {
                        jgEquipTransfer.setInstanceStatus(jgEquipTransfer.getInstanceStatus() + "," + String.join(",", roleList));
                    } else {
                        jgEquipTransfer.setInstanceStatus(String.join(",", roleList));
                    }
                    jgEquipTransfer.setPromoter(userId);
                    jgEquipTransfer.setApplyStatus(String.valueOf(FlowStatusEnum.TO_BE_PROCESSED.getCode()));
                }
            } else {
                //驳回
                jgEquipTransfer.setPromoter("");
                jgEquipTransfer.setApplyStatus(String.valueOf(FlowStatusEnum.REJECTED.getCode()));
            }
            updateById(jgEquipTransfer);
        }
    }

    public boolean submit(JgEquipTransfer transfer,String op) {
        AjaxResult ajaxResult = Workflow.taskClient.getTask(transfer.getInstanceId());
        JSONObject dataObject = JSON.parseObject(JSON.toJSONString(ajaxResult.get("data")));
        String taskId = dataObject.getString("id");
        //组装信息
        TaskResultDTO dto = new TaskResultDTO();
        dto.setResultCode("approvalStatus");
        dto.setTaskId(taskId);
        dto.setComment("提交流程");
        HashMap<String, Object> map = new HashMap<>();
        map.put("approvalStatus", op);
        dto.setVariable(map);
        //执行流程
        AjaxResult ajaxResult1 = null;
        try {
            ajaxResult1 = Workflow.taskClient.completeByTask(taskId, dto);
            return ajaxResult1.get("code").equals(200);
        } catch (Exception e) {
            log.error("提交失败：{}", e.getMessage());
            return false;
        }
    }

    public void cancel(JgEquipTransferDto equipTransferInfo) {
        FeignClientResult ajaxResult = Workflow.taskV2Client.rollBack(equipTransferInfo.getInstanceId());
        JgEquipTransfer equipTransfer = this.baseMapper.selectById(equipTransferInfo.getSequenceNbr());
        if (ajaxResult.getStatus() == 200) {
            equipTransfer.setApplyStatus(String.valueOf(FlowStatusEnum.TO_BE_SUBMITTED.getCode()));
            this.baseMapper.updateById(equipTransfer);
        }
    }

    public JgEquipTransferDto updateEquipTransfer(String submitType, JgEquipTransferDto equipTransferDto, String op) {
        if (Objects.isNull(equipTransferDto) || StringUtils.isEmpty(submitType))
            throw new IllegalArgumentException("参数不能为空");
        String[] taskName = new String[]{"流程结束"};
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(
                RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        // 字段转换
        this.convertField(equipTransferDto);
        ArrayList<String> roleListFirst = new ArrayList<>();
        ArrayList<String> roleListSecond = new ArrayList<>();
        if (SUBMIT_TYPE_FLOW.equals(submitType)) {
            AjaxResult ajaxResult;
            // 发起流程
            if (!org.springframework.util.StringUtils.hasText(equipTransferDto.getInstanceId())) {
                ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                dto.setProcessDefinitionKey(EQUIP_TRANSFER_PROCESS_KEY);
                dto.setBusinessKey("1");
                try {
                    ajaxResult = Workflow.taskClient.startByVariable(dto);
                    String instanceId = ((Map) ajaxResult.get("data")).get("id").toString();
                    equipTransferDto.setInstanceId(instanceId);
                    // 查询下节点任务
                    getNext(roleListFirst, instanceId,taskName);
                    equipTransferDto.setInstanceStatus(String.join(",", roleListFirst));
                } catch (Exception e) {
                    log.error("提交失败：{}", e.getMessage());
                    throw new RuntimeException(e);
                }
            }
            JgEquipTransfer transfer = new JgEquipTransfer();
            BeanUtils.copyProperties(equipTransferDto,transfer);

            boolean submit = submit(transfer, op);

            if(submit) {
                // 查询下节点任务
                getNext(roleListSecond, transfer.getInstanceId(),taskName);
                transfer.setApplyStatus(taskName[0]);
                if (!org.springframework.util.ObjectUtils.isEmpty(transfer.getInstanceStatus())) {
                    transfer.setInstanceStatus(transfer.getInstanceStatus() + "," + roleListSecond);
                } else {
                    transfer.setInstanceStatus(String.join(",", roleListSecond));
                }
                transfer.setPromoter(RequestContext.getExeUserId());
                transfer.setNextExecuteIds(String.join(",", roleListSecond));
                transfer.setApplyStatus(String.valueOf(FlowStatusEnum.TO_BE_PROCESSED.getCode()));
                updateById(transfer);
            }
        } else {
            JgEquipTransfer bean = new JgEquipTransfer();
            BeanUtils.copyProperties(equipTransferDto, bean);
            updateById(bean);
        }
        return equipTransferDto;
    }
}