package com.yeejoin.amos.boot.module.ymt.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 安全追溯-锅炉
 *
 * @author system_generator
 * @date 2023-08-17
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="IdxBizJgTechParamsBoilerDto", description="安全追溯-锅炉")
public class IdxBizJgTechParamsBoilerDto  extends BaseDto {

   private static final long serialVersionUID = 1L;




    @TableField("RECORD")
    private String record;



    @TableField("INSTANCE_ID")
    private String instanceId;

    @TableField("STATUS")
    private String status;

    @ApiModelProperty(value = "设备等级")
    @TableField("DEVICE_LEVEL")
    private String deviceLevel;

    @ApiModelProperty(value = "额定蒸发量（热功率）")
    @TableField("RATED_EVAPORATION_CAPACITY_THERMAL_POWER")
    private String ratedEvaporationCapacityThermalPower;

    @ApiModelProperty(value = "额定工作压力")
    @TableField("RATED_WORKING_PRESSURE")
    private String ratedWorkingPressure;

    @ApiModelProperty(value = "额定工作温度")
    @TableField("RATED_OPERATING_TEMPERATURE")
    private String ratedOperatingTemperature;

    @ApiModelProperty(value = "设计热效率")
    @TableField("DESIGN_THERMAL_EFFICIENCY")
    private String designThermalEfficiency;

    @ApiModelProperty(value = "给水温度")
    @TableField("FEEDWATER_TEMPERATURE")
    private String feedwaterTemperature;

    @ApiModelProperty(value = "额定出/回水(油)温度")
    @TableField("RATED_OUTLET_RETURN_WATER_OIL_TEMPERATURE")
    private String ratedOutletReturnWaterOilTemperature;

    @ApiModelProperty(value = "锅炉本体水（油）容积")
    @TableField("WATER_OIL_VOLUME_OF_BOILER_PROPER")
    private String waterOilVolumeOfBoilerProper;

    @ApiModelProperty(value = "整装锅炉本体液压试验介质/压力")
    @TableField("HYDRAULIC_TEST_MEDIUM_PRESSURE_OF_PACKAGED_BOILER_BODY")
    private String hydraulicTestMediumPressureOfPackagedBoilerBody;

    @ApiModelProperty(value = "再热器进（出）口温度")
    @TableField("INLET_OUTLET_TEMPERATURE_OF_REHEATER")
    private String inletOutletTemperatureOfReheater;

    @ApiModelProperty(value = "再热器进（出）口压力")
    @TableField("REHEATER_INLET_OUTLET_PRESSURE")
    private String reheaterInletOutletPressure;

    @ApiModelProperty(value = "再热蒸汽流量")
    @TableField("REHEAT_STEAM_FLOW")
    private String reheatSteamFlow;

    @ApiModelProperty(value = "有机热载体锅炉气密试验介质/压力")
    @TableField("GL_AIRTIGHT_TEST")
    private String glAirtightTest;

    @ApiModelProperty(value = "燃料（热源）种类")
    @TableField("FUEL_TYPE")
    private String fuelType;

    @ApiModelProperty(value = "受压部件名称")
    @TableField("NAME_OF_PRESSURE_PARTS")
    private String nameOfPressureParts;

    @ApiModelProperty(value = "受压部件材料")
    @TableField("MATERIAL_OF_PRESSURE_PARTS")
    private String materialOfPressureParts;

    @ApiModelProperty(value = "受压部件壁厚")
    @TableField("WALL_THICKNESS_OF_PRESSURE_PARTS")
    private String wallThicknessOfPressureParts;

    @ApiModelProperty(value = "受压部件无损检测方法")
    @TableField("NON_DESTRUCTIVE_TESTING_METHODS_FOR_PRESSURE_PARTS")
    private String nonDestructiveTestingMethodsForPressureParts;

    @ApiModelProperty(value = "受压部件无损检测比例")
    @TableField("PROPORTION_OF_NDT_FOR_PRESSURE_PARTS")
    private String proportionOfNdtForPressureParts;

    @ApiModelProperty(value = "受压部件热处理温度")
    @TableField("HEAT_TREATMENT_TEMPERATURE_OF_PRESSURE_PARTS")
    private String heatTreatmentTemperatureOfPressureParts;

    @ApiModelProperty(value = "受压部件热处理时间")
    @TableField("HEAT_TREATMENT_TIME_OF_PRESSURE_PARTS")
    private String heatTreatmentTimeOfPressureParts;

    @ApiModelProperty(value = "受压部件水（耐）压试验介质")
    @TableField("HYDROSTATIC_TEST_MEDIUM")
    private String hydrostaticTestMedium;

    @ApiModelProperty(value = "受压部件水（耐）压试验压力")
    @TableField("HYDROSTATIC_TEST_PRESSURE")
    private String hydrostaticTestPressure;

    @ApiModelProperty(value = "燃烧方式")
    @TableField("COMBUSTION_MODE")
    private String combustionMode;

}
