package com.yeejoin.precontrol.common.vo;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

import com.yeejoin.precontrol.common.annotations.ImagePrefix;

/**
 * 该部门下的人员奖励兑换记录
 *
 * @author duanwei
 * @date 2021-04-06
 */
@Data
public class RewardOrgCodeVo implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * 奖励人id
	 */
	@ApiModelProperty(value = "奖励人id")
	private Long personId;
	/**
	 * 奖励人姓名
	 */
	@ApiModelProperty(value = "奖励人姓名")
	private String userName;
	/**
	 * 公司名称
	 */
	@ApiModelProperty(value = "公司名称")
	private String companyName;
	/**
	 * 公司Id
	 */
	@ApiModelProperty(value = "公司Id")
	private String companyId;
	/**
	 * 奖励人头像
	 */
	@ApiModelProperty(value = "奖励人头像")
	@ImagePrefix
	private String headPhoto;
	/**
	 * 奖励人角色
	 */
	@ApiModelProperty(value = "奖励人角色")
	private String roleName;
	/**
	 * 奖励人身份证
	 */
	@ApiModelProperty(value = "奖励人身份证")
	private String cardId;
	/**
	 * 项目名称
	 */
	@ApiModelProperty(value = "项目名称")
	private String projectName;
	/**
	 * 累计违章检查数量
	 */
	@ApiModelProperty(value = "累计违章检查数量")
	private Integer sumViolationCount;
	/**
	 * 累计奖励金额
	 */
	@ApiModelProperty(value = "累计奖励金额")
	private BigDecimal sumRewardMoney;

	/**
	 * 已发放违章检查数量
	 */
	@ApiModelProperty(value = "已发放违章检查数量")
	private Integer issuedViolationCount;

	/**
	 * 已发放奖励金额
	 */
	@ApiModelProperty(value = "已发放奖励金额")
	private BigDecimal issuedRewardMoney;
	/**
	 * 未发放违章检查数量
	 */
	@ApiModelProperty(value = "未发放违章检查数量")
	private Integer unissuedViolationCount;
	/**
	 * 未发放奖励金额
	 */
	@ApiModelProperty(value = "未发放奖励金额")
	private BigDecimal unissuedRewardMoney;

	@ApiModelProperty(value = "排序")
	private String sort;

	@ApiModelProperty(value = "排序字段名")
	private String sortName;
	
	@ApiModelProperty(value = "排序顺序")
	private String sortOrder;
}
