package com.yeejoin.amos.boot.module.tdc.biz.controller;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.tdc.api.service.ModelItemService;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.Map;

/**
 * 校验项提交
 * @author xxz
 */
@RestController
@Api(tags = "校验项提交")
@RequestMapping(value = "/check-item")
public class ModelItemController extends BaseController {


    @Autowired
    ModelItemService modelItemService;

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @PostMapping(value = "/saveModelItem")
    @ApiOperation(httpMethod = "POST", value = "保存模型项", notes = "保存模型项")
    public ResponseModel saveModelItem(@RequestBody JSONObject jsonObject){
        AgencyUserModel userInfo = getUserInfo();
        if (ObjectUtils.isEmpty(jsonObject)) {
            return null;
        }
        Object sequenceNbr = jsonObject.get("sequenceNbr");
        if (ObjectUtils.isEmpty(sequenceNbr)) {
            modelItemService.saveModelItem(jsonObject, userInfo);
            return ResponseHelper.buildResponse(true);
        }
        modelItemService.editModelItem(jsonObject, userInfo);
        return ResponseHelper.buildResponse(true);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/getModelItem")
    @ApiOperation(httpMethod = "GET", value = "获取模型项", notes = "获取模型项")
    public ResponseModel<Map<String, Object>> getModelItem(@RequestParam(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(modelItemService.getModelItem(sequenceNbr));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/deleteModelItem")
    @ApiOperation(httpMethod = "GET", value = "删除模型项", notes = "删除模型项")
    public ResponseModel deleteModelItem(@RequestParam(value = "sequenceNbr") String sequenceNbr){
        modelItemService.deleteModelItem(sequenceNbr);
        return ResponseHelper.buildResponse(true);
    }
}
