package com.yeejoin.amos.boot.module.jg.api.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.util.HashMap;
import java.util.Map;

public class ChargingMediumConverter implements Converter<String> {

    private static final Map<String, String> EXCEL_TO_JAVA_MAP = new HashMap<>();
    private static final Map<String, String> JAVA_TO_EXCEL_MAP = new HashMap<>();

    static {
        EXCEL_TO_JAVA_MAP.put("液化天然气", "LIQUEFIED_NATURAL_GAS");
        EXCEL_TO_JAVA_MAP.put("液化石油气", "LIQUEFIED_PETROLEUM_GAS");
        EXCEL_TO_JAVA_MAP.put("压缩天然气", "COMPRESSED_NATURAL_GAS");

        JAVA_TO_EXCEL_MAP.put("LIQUEFIED_NATURAL_GAS", "液化天然气");
        JAVA_TO_EXCEL_MAP.put("LIQUEFIED_PETROLEUM_GAS", "液化石油气");
        JAVA_TO_EXCEL_MAP.put("COMPRESSED_NATURAL_GAS", "压缩天然气");
    }

    @Override
    public Class<?> supportJavaTypeKey() {
        return String.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public String convertToJavaData(CellData cellData, ExcelContentProperty excelContentProperty,
                                    GlobalConfiguration globalConfiguration) {
        return EXCEL_TO_JAVA_MAP.getOrDefault(cellData.getStringValue(), "COMPRESSED_NATURAL_GAS");
    }

    @Override
    public CellData convertToExcelData(String o, ExcelContentProperty excelContentProperty,
                                       GlobalConfiguration globalConfiguration) {
        return new CellData(JAVA_TO_EXCEL_MAP.getOrDefault(o, "压缩天然气"));
    }
}
