package com.yeejoin.amos.boot.module.jg.api.enums;

/**
 * 办理状态枚举
 */
public enum CancelTypeEnum {

    /**
     * 报废注销
     */
    SCRAPPED("1", "报废注销"),
    /**
     * 移装注销
     */
    TRANSFER("2", "移装注销");

    private final String code;

    private final String name;

    CancelTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getNameByType(String code) {
        String name = null;
        for (CancelTypeEnum enumOne : CancelTypeEnum.values()) {
            if (enumOne.getCode().equals(code)) {
                name = enumOne.getName();
                break;
            }
        }
        return name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
