package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yeejoin.equipmanage.common.entity.VideoImportantEquipment;
import com.yeejoin.equipmanage.common.vo.VideoImportantEquipmentVo;
import com.yeejoin.equipmanage.mapper.VideoImportantEquipmentMapper;
import com.yeejoin.equipmanage.service.IVideoImportantEquipmentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author ZeHua Li
 * @date 2020/11/25 15:49
 * @since v2.0
 */
@Service
public class VideoImportantEquipmentServiceImpl extends ServiceImpl<VideoImportantEquipmentMapper,VideoImportantEquipment> implements IVideoImportantEquipmentService {

    @Autowired
    private VideoImportantEquipmentMapper videoImportantEquipmentMapper;

    @Override
    public List<VideoImportantEquipmentVo> getVideoImportantEquipmentList(Map<String, Object> map) {
        return videoImportantEquipmentMapper.getVideoImportantEquipmentList(map);
    }

    @Override
    public List<Map<String, List<VideoImportantEquipmentVo>>> getVideoList(Map<String, Object> map) {
        ArrayList<Map<String, List<VideoImportantEquipmentVo>>> maps = new ArrayList<>();
        List<VideoImportantEquipmentVo> videoList = videoImportantEquipmentMapper.getVideoList(map);
        List<String> videoAddressGroupList = videoImportantEquipmentMapper.getVideoAddressGroupList(map);
        for (String address : videoAddressGroupList) {
            if (!ObjectUtils.isEmpty(address)) {
                List<VideoImportantEquipmentVo> collect = videoList.stream().filter(item -> item.getAddress().equals(address)).collect(Collectors.toList());
                if (collect.size() > 0) {
                    HashMap<String, List<VideoImportantEquipmentVo>> listMap = new HashMap<>();
                    listMap.put(address, collect);
                    maps.add(listMap);
                }
            }
        }
        return maps;
    }
}
