package com.yeejoin.amos.boot.module.tdc.biz.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.tdc.api.dto.CheckResultDto;
import com.yeejoin.amos.boot.module.tdc.api.dto.DimensionTableDto;
import com.yeejoin.amos.boot.module.tdc.api.dto.ModelTreeDto;
import com.yeejoin.amos.boot.module.tdc.api.entity.CheckResult;
import com.yeejoin.amos.boot.module.tdc.api.service.CheckResultService;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;
import java.util.Map;


/**
 * 校验结果
 * @author xxz
 */
@RestController
@Api(tags = "校验结果Api")
@RequestMapping(value = "/check-result")
public class CheckResultController extends BaseController {

    @Autowired
    CheckResultService checkResultService;

    /**
     * cs
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/selectResult")
    @ApiOperation(httpMethod = "GET", value = "result", notes = "result")
    public ResponseModel<IPage<CheckResultDto>> selectResult(int current,int size,String code) {
        return ResponseHelper.buildResponse(checkResultService.selectResult(current, size, code));
    }

    /**
     * 根据batchNo查询不合格项
     * return
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/selectCheckResult")
    @ApiOperation(httpMethod = "GET",value = "根据batchNo查询不合格项",  notes = "根据batchNo查询不合格项")
    public ResponseModel<List<CheckResult>> selectCheckResult( String batchNo) {
        return ResponseHelper.buildResponse(checkResultService.selectCheckResult(batchNo));
    }

    /**
     * 根据batchNo统计校验项和不合格项
     * return
     * @return
     */

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/selectTotal")
    @ApiOperation(httpMethod = "GET", value = "根据batchNo统计校验项和不合格项", notes = "根据batchNo统计校验项和不合格项")
    public ResponseModel<Map<String, Object>> selectTotal(String batchNo) {
        return ResponseHelper.buildResponse(checkResultService.selectTotal(batchNo));
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/getAllModelDataTree/{amosOrgCode}")
    @ApiOperation(httpMethod = "GET",value = "获取机构下模型树",  notes = "根据机构code获取模型树")
    public ResponseModel<List<ModelTreeDto>> getAllModelDataTree(@PathVariable(value = "amosOrgCode") String amosOrgCode) {
        return ResponseHelper.buildResponse(checkResultService.getAllModelDataTree(amosOrgCode));
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/getModelDataTree/{modelId}")
    @ApiOperation(httpMethod = "GET",value = "获取单独模型树",  notes = "根据模型id获取模型树")
    public ResponseModel<List<ModelTreeDto>> getModelDataTree(@PathVariable(value = "modelId") String modelId) {
        return ResponseHelper.buildResponse(checkResultService.getModelDataTree(modelId));
    }


    /**
     * cs
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/selectDetails/")
    @ApiOperation(httpMethod = "GET", value = "result", notes = "result")
    public ResponseModel<List<CheckResultDto>> selectDetails( String batchNo,int modelId) {
        return ResponseHelper.buildResponse(checkResultService.selectDetails(batchNo,modelId));
    }

    /**
     * cs
     */
//    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
//    @GetMapping(value = "/saveSql")
//    @ApiOperation(httpMethod = "GET", value = "result", notes = "result")
//    public ResponseModel<String> saveSql(String amosOrgCode) {
//        AgencyUserModel user = getUserInfo();
//        return ResponseHelper.buildResponse(checkResultService.saveSql(amosOrgCode,user.getUserName()));
//    }

    /**
     * cs
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
    @GetMapping(value = "/getDimensionTable")
    @ApiOperation(httpMethod = "GET", value = "result", notes = "result")
    public ResponseModel<List<DimensionTableDto>> getDimensionTable(String id) {
        return ResponseHelper.buildResponse(checkResultService.getDimensionTable(id));
    }


}
