package com.yeejoin.equipmanage.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.google.common.collect.Lists;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarm;
import com.yeejoin.equipmanage.common.entity.EquipmentSpecificAlarmLog;
import com.yeejoin.equipmanage.mapper.EquipmentSpecificAlarmLogMapper;
import com.yeejoin.equipmanage.service.IEquipmentSpecificAlarmLogService;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author keyong
 * @title: EquipmentSpecificAlarmLogServiceImpl
 * <pre>
 * @description: TODO
 * </pre>
 * @date 2021/8/19 10:37
 */
@Service
public class EquipmentSpecificAlarmLogServiceImpl extends ServiceImpl<EquipmentSpecificAlarmLogMapper, EquipmentSpecificAlarmLog> implements IEquipmentSpecificAlarmLogService {

    @Autowired
    EquipmentSpecificAlarmLogMapper equipmentSpecificAlarmLogMapper;

    @Override
    public void updateAlarmLogByIotCodeAndIndexKey(EquipmentSpecificAlarm equipmentSpecificAlarm) {
        equipmentSpecificAlarmLogMapper.updateAlarmLogByIotCodeAndIndexKey(equipmentSpecificAlarm);
    }

    @Override
    public List<EquipmentSpecificAlarmLog> getIsConfirmByAlarmId(Long equipmentSpecificAlarmId, String isConfirm) {
        List<EquipmentSpecificAlarmLog> list = equipmentSpecificAlarmLogMapper.getIsConfirmByAlarmId(equipmentSpecificAlarmId, isConfirm);
        if (CollectionUtils.isNotEmpty(list)) {
            return list;
        }
        return Lists.newArrayList();
    }
}
