package com.yeejoin.precontrol.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.precontrol.common.entity.Company;
import com.yeejoin.precontrol.common.param.CompanyParam;
import com.yeejoin.precontrol.common.vo.BadCompanyVo;
import com.yeejoin.precontrol.common.vo.CompanyExcelVo;
import com.yeejoin.precontrol.common.vo.CompanyVo;
import org.apache.ibatis.annotations.Param;

import java.util.HashMap;
import java.util.List;

/**
 * 企业基本信息 Mapper 接口
 *
 * @author duanwei
 * @date 2020-06-30
 */
public interface CompanyMapper extends BaseMapper<Company> {

	List<CompanyVo> pageInfo(@Param("param") CompanyParam param, Page<CompanyVo> page);

	List<HashMap<String, Object>> companySelect();

	List<CompanyExcelVo> exportExcel(CompanyParam param);

	List<BadCompanyVo> badCompany(IPage<BadCompanyVo> page, @Param("isBad") boolean isBad,
			@Param("isAllStatus") boolean isAllStatus, @Param("badCompanyVo") BadCompanyVo badCompanyVo);

	List<CompanyVo> redPersonCompany(int redPersonCount);
}
