package com.yeejoin.precontrol.common.vo;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.yeejoin.precontrol.common.dto.BaseDto;
import org.springframework.format.annotation.DateTimeFormat;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.precontrol.common.annotations.ImagePrefix;
import com.yeejoin.precontrol.common.entity.Person;
import com.yeejoin.precontrol.common.entity.TaskPersonFeedback;
import com.yeejoin.precontrol.common.entity.TaskSalaryConfirmAttachment;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 薪资确认任务表Vo
 *
 * @author duanwei
 * @date 2020-12-08
 */
@Data
public class TaskSalaryConfirmOneVo extends BaseDto implements Serializable {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "任务id")
	/**
	 * 任务id
	 */
	private Long taskId;
	@ApiModelProperty(value = "项目id")
	/**
	 * 项目id
	 */
	private Long projectId;
	@ApiModelProperty(value = "项目名称")
	/**
	 * 项目名称
	 */
	private String projectName;
	@ApiModelProperty(value = "分包商id")
	/**
	 * 分包商id
	 */
	private Long companyId;
	@ApiModelProperty(value = "分包商名称")
	/**
	 * 项目名称
	 */
	private String companyName;
	@ApiModelProperty(value = "付款批次")
	/**
	 * 付款批次
	 */
	private String payBatch;
	@ApiModelProperty(value = "银行账户")
	/**
	 * 银行账户
	 */
	private String bankAccount;
	@ApiModelProperty(value = "付款开始时间")
	/**
	 * 付款开始时间
	 */
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date payStartTime;
	@ApiModelProperty(value = "付款结束时间")
	/**
	 * 付款结束时间
	 */
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date payEndTime;
	@ApiModelProperty(value = "发放类型")
	/**
	 * 发放类型
	 */
	private String payType;
	@ApiModelProperty(value = "发放日期")
	/**
	 * 发放日期
	 */
	@DateTimeFormat(pattern = "yyyy-MM-dd")
	@JsonFormat(pattern = "yyyy-MM-dd")
	private Date payDate;
	/**
	 * 任务状态
	 */
	@ApiModelProperty(value = "任务状态")
	private Integer status;

	/**
	 * 超时状态
	 */
	@ApiModelProperty(value = "超时状态")
	private Integer currentStatus;

	/**
	 * 附件列表
	 */
    @ApiModelProperty(value = "附件")
    @ImagePrefix
    private List<TaskSalaryConfirmAttachment> attachment;
	@ApiModelProperty(value = "薪资")
	/**
	 *薪资
	 */
    private BigDecimal salary;
	@ApiModelProperty(value = "阅读状态")
	/**
	 * 阅读状态
	 */
	private Integer readStatus;
	@ApiModelProperty(value = "阅读时间")
	/**
	 * 阅读时间
	 */
	private Date readTime;
	@ApiModelProperty(value = "出勤天数")
	/**
	 * 出勤天数
	 */
    private Integer clockDays;
	
	/**
	 * 个人id
	 */
	private Long personId;
	
	/**
	 * 任务个人id
	 */
	private Long taskPersonId;
	
	/**
	 * 反馈列表
	 */
	private List<TaskPersonFeedback> feedbackList;
	
	/**
	 * 人员信息
	 */
	@ImagePrefix
	private Person person;
	
	/**
	 * 是否阅读（红点）
	 */
	private boolean firstRead;
}
