package com.yeejoin.amos.boot.module.jg.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.common.BizCustomDateSerializer;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 更名变更登记
 *
 * @author system_generator
 * @date 2023-12-25
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_jg_change_registration_name")
public class JgChangeRegistrationName extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 申请编号
     */
	@TableField("apply_no")
    private String applyNo;

    /**
     * 申请日期
     */
	@TableField("apply_date")
    private Date applyDate;

    /**
     * 办理状态
     */
	@TableField("audit_status")
    private String auditStatus;

    /**
     * 登记机构
     */
	@TableField("receive_org_name")
    private String receiveOrgName;

    /**
     * 登记机构代码
     */
	@TableField("receive_org_code")
    private String receiveOrgCode;

    /**
     * 登记机构公司代码
     */
	@TableField("receive_company_code")
    private String receiveCompanyCode;

    /**
     * 终审通过时间
     */
	@TableField("audit_pass_date")
    private Date auditPassDate;

    /**
     * 备注
     */
	@TableField("remark")
    private String remark;

    /**
     * 创建人ID
     */
	@TableField("create_user_id")
    private String createUserId;

    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
	@TableField("create_date")
    private Date createDate;

    /**
     * 创建人
     */
	@TableField("create_user_name")
    private String createUserName;

    /**
     * 使用单位统一信用代码
     */
	@TableField("use_unit_credit_code")
    private String useUnitCreditCode;

    /**
     * 原使用单位名称
     */
	@TableField("use_unit_name")
    private String useUnitName;

    /**
     * 新使用单位名称
     */
	@TableField("new_use_unit_name")
    private String newUseUnitName;

    /**
     * 证照图片（更名后证照）
     */
	@TableField("change_certificate")
    private String changeCertificate;

    /**
     * 流程实例id
     */
	@TableField("instance_id")
    private String instanceId;

    /**
     * 流程执行顺序标识
     */
	@TableField("execute_sequence")
    private String executeSequence;

    /**
     * 下一执行节点ids
     */
	@TableField("next_executor_ids")
    private String nextExecutorIds;

    /**
     * 任务发起人id
     */
	@TableField("promoter")
    private String promoter;

    /**
     * 流程状态
     */
    @TableField("instance_status")
    private String instanceStatus;

    /**
     * 下一步任务id
     */
    @TableField("next_task_id")
    private String nextTaskId;

    /**
     * 下一节点可执行人
     */
    @TableField("next_execute_user_ids")
    private String nextExecuteUserIds;

    /**
     * 转办后执行人的Id逗号分割
     */
    @TableField("transfer_to_user_ids")
    private String transferToUserIds;
}
