package com.yeejoin.amos.boot.module.jg.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.common.BizCustomDateSerializer;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author system_generator
 * @date 2023-12-12
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_jg_installation_notice")
public class JgInstallationNotice extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 告知单编号
     */
    @TableField("apply_no")
    private String applyNo;

    /**
     * 设备监管码
     */
    @TableField("supervisory_code")
    private String supervisoryCode;

    /**
     * 设备种类
     */
    @TableField("equ_list")
    private String equList;

    /**
     * 告知状态
     */
    @TableField("notice_status")
    private String noticeStatus;

    /**
     * 设备数量
     */
    @TableField("device_num")
    private Integer deviceNum;

    /**
     * 安装单位统一信用代码
     */
    @TableField("install_unit_credit_code")
    private String installUnitCreditCode;

    /**
     * 安装许可证编号
     */
    @TableField("install_license_no")
    private String installLicenseNo;

    /**
     * 安装单位名称
     */
    @TableField("install_unit_name")
    private String installUnitName;

    /**
     * 安装许可有效期
     */
    @TableField("install_license_expiration_date")
    private Date installLicenseExpirationDate;

    /**
     * 安装地点-区域代码
     */
    @TableField("region_no")
    private String regionNo;

    /**
     * 安装地点_省
     */
    @TableField("province")
    private String province;

    /**
     * 安装地点_省
     */
    @TableField("province_name")
    private String provinceName;

    /**
     * 安装地点_市
     */
    @TableField("city")
    private String city;

    /**
     * 安装地点_市
     */
    @TableField("city_name")
    private String cityName;

    /**
     * 设备使用地点_区（县）
     */
    @TableField("county")
    private String county;

    /**
     * 设备使用地点_区（县）
     */
    @TableField("county_name")
    private String countyName;

    /**
     * 安装地点_街道（镇）
     */
    @TableField("street")
    private String street;

    /**
     * 设备详细使用地址
     */
    @TableField("address")
    private String address;

    /**
     * 安装负责人ID
     */
    @TableField("install_leader_id")
    private String installLeaderId;

    /**
     * 安装负责人
     */
    @TableField("install_leader_name")
    private String installLeaderName;

    /**
     * 安装负责人手机
     */
    @TableField("install_leader_phone")
    private String installLeaderPhone;

    /**
     * 安装开始日期
     */
    @TableField("install_start_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date installStartDate;

    /**
     * 安装竣工日期
     */
    @TableField("install_end_date")
    private Date installEndDate;

    /**
     * 产权单位统一信用代码
     */
    @TableField("property_unit_credit_code")
    private String propertyUnitCreditCode;

    /**
     * 产权单位
     */
    @TableField("property_unit_name")
    private String propertyUnitName;

    /**
     * 使用单位统一信用代码
     */
    @TableField("use_unit_credit_code")
    private String useUnitCreditCode;

    /**
     * 使用单位
     */
    @TableField("use_unit_name")
    private String useUnitName;

    /**
     * 接收机构统一信用代码
     */
    @TableField("receive_org_credit_code")
    private String receiveOrgCreditCode;

    /**
     * 接收机构
     */
    @TableField("receive_org_name")
    private String receiveOrgName;

    /**
     * 安装类型
     */
    @TableField("install_type")
    private String installType;

    /**
     * 委托单位
     */
    @TableField("entrusting_unit_name")
    private String entrustingUnitName;

    /**
     * 安装方案
     */
    @TableField("install_plan")
    private String installPlan;

    /**
     * 流程建议
     */
    @TableField("process_advice")
    private String processAdvice;

    /**
     * 撤销原由
     */
    @TableField("cancel_reason")
    private String cancelReason;

    /**
     * 撤销说明
     */
    @TableField("cancel_remark")
    private String cancelRemark;

    /**
     * 撤销处理截止日期
     */
    @TableField("cancel_handle_deadline")
    private Date cancelHandleDeadline;

    /**
     * 撤销流水号
     */
    @TableField("cancel_process_no")
    private String cancelProcessNo;

    /**
     * 施工合同是否本单位与甲方直接签署
     */
    @TableField("is_signed_with_a")
    private String isSignedWithA;

    /**
     * 检验单位代码
     */
    @TableField("inspect_unit_id")
    private String inspectUnitId;

    /**
     * 检验单位
     */
    @TableField("inspect_unit_name")
    private String inspectUnitName;

    /**
     * 是否已报检
     */
    @TableField("is_inspected")
    private String isInspected;

    /**
     * 设备安装质量证明书编号
     */
    @TableField("install_cert_no")
    private String installCertNo;

    /**
     * 审核通过时间
     */
    @TableField("receive_time")
    private Date receiveTime;

    /**
     * 状态
     */
    @TableField("status")
    private String status;

    /**
     * 备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 创建人ID
     */
    @TableField("create_user_id")
    private String createUserId;

    /**
     * 创建时间
     */
    @TableField("create_date")
    private Date createDate;

    /**
     * 录入单位ID
     */
    @TableField("input_unit_no")
    private String inputUnitNo;

    /**
     * 安装委托书图片
     */
    @TableField("proxy_statement_attachment")
    private String proxyStatementAttachment;

    /**
     * 安装合同照片
     */
    @TableField("install_contract_attachment")
    private String installContractAttachment;

    /**
     * 是否西咸
     */
    @TableField("is_xixian")
    private String isXixian;

    /**
     * 告知日期
     */
    @TableField("notice_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date noticeDate;

    /**
     * 流程实例id
     */
    @TableField("instance_id")
    private String instanceId;

    /**
     * 告知单PDF URL
     */
    @TableField("notice_report_url")
    private String noticeReportUrl;

    /**
     * 设备注册编码
     */
    @TableField("equ_register_code")
    private String equRegisterCode;

    /**
     *  	 * 设备使用地点-街道（镇）
     *      */

    @TableField(value ="\"factory_use_site_street\"")
    private String factoryUseSiteStreet;

    /**
     *  	 * 设备使用地点-街道（镇）-名称
     *      */

    @TableField(value ="\"street_name\"")
    private String streetName;



    @TableField("next_execute_ids")
    private String nextExecuteIds;


    @TableField(value = "promoter")
    private String promoter;

    @TableField("instance_status")
    private String instanceStatus;


    @TableField("equ_address")
    private String equAddress;

    @TableField("handle_date")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date handleDate;

    /**
     * 流程任务状态（来源工作流）
     */
    private String approvalStatus;


    @TableField(value = "\"create_user_company_name\"")
    private String createUserCompanyName;

    //下一步任务ID
    @TableField(value = "\"next_task_id\"")
    private String nextTaskId;

    /**
     * 创建人
     */
    @TableField("\"create_user_name\"")
    private String createUserName;

    /**
     * 设备出场编号
     */
    @TableField(exist = false)
    private String factoryNum;

    /**
     * 下一节点可执行人
     */
    @TableField("\"next_execute_user_ids\"")
    private String nextExecuteUserIds;


    @TableField(value = "transfer_to_user_ids")
    private String transferToUserIds;

    /**
     * 属地监管部门code
     */
    @TableField(value = "org_branch_code")
    private String orgBranchCode;

    /**
     * 属地监管部门name
     */
    @TableField(value = "org_branch_name")
    private String orgBranchName;

    /**
     * 告知书编号
     */
    @TableField(value = "inform_number")
    private String informNumber;
}
