package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.map.MapBuilder;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.yeejoin.amos.boot.biz.common.bo.CompanyBo;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jg.api.dto.*;
import com.yeejoin.amos.boot.module.jg.api.entity.*;
import com.yeejoin.amos.boot.module.jg.api.enums.BusinessTypeEnum;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgEquipTransferEqMapper;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgEquipTransferMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgEquipTransferService;
import com.yeejoin.amos.boot.module.jg.api.service.IJgInstallationNoticeService;
import com.yeejoin.amos.boot.module.jg.biz.feign.TzsServiceFeignClient;
import com.yeejoin.amos.boot.module.jg.biz.service.IIdxBizJgRegisterInfoService;
import com.yeejoin.amos.boot.module.ymt.api.common.BaseException;
import com.yeejoin.amos.boot.module.ymt.api.enums.ApplicationFormTypeEnum;
import com.yeejoin.amos.boot.module.ymt.api.enums.FlowStatusEnum;
import com.yeejoin.amos.feign.systemctl.model.TaskV2Model;
import com.yeejoin.amos.feign.workflow.model.*;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

/**
 * 设备移交服务实现类
 *
 * @author LiuLin
 * @date 2023-12-20
 */
@Slf4j
@Service
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class JgEquipTransferServiceImpl extends BaseService<JgEquipTransferDto, JgEquipTransfer, JgEquipTransferMapper> implements IJgEquipTransferService {
    private static final String EQUIP_TRANSFER_PROCESS_KEY = "equipmentHandover";
    private static final String SUBMIT_TYPE_FLOW = "1";
    private final JgEquipTransferEqMapper jgEquipTransferEqMapper;
    private final RedisUtils redisUtils;
    private final TzsServiceFeignClient tzsServiceFeignClient;
    private final CommonServiceImpl commonService;
    private final CmWorkflowServiceImpl cmWorkflowService;
    private final IJgInstallationNoticeService jrmInstallationNoticeService;
    private final IIdxBizJgRegisterInfoService idxBizJgRegisterInfoService;

    /**
     * 保存和保存并提交
     *
     * @param submitType    保存或保存并提交
     * @param jsonObjectMap 设备移交和设备信息
     * @param reginParams   redis信息
     */
    @Transactional(rollbackFor = {Exception.class, BaseException.class})
    public List<JgEquipTransfer> saveTransfer(String submitType, JSONObject jsonObjectMap, ReginParams reginParams) {
        JgEquipTransferDto model = JSON.parseObject(JSONObject.toJSONString(jsonObjectMap), JgEquipTransferDto.class);

        convertField(model);
        List<Map<String, Object>> deviceList = model.getDeviceList();
        if (CollectionUtils.isEmpty(deviceList)) {
            throw new BadRequest("请选择设备!");
        }

        //获取申请单编号
        ResponseModel<List<String>> listResponseModel = tzsServiceFeignClient.applicationFormCode(ApplicationFormTypeEnum.getCode.get(String.valueOf(jsonObjectMap.get("businessCode"))), deviceList.size());
        this.handleResponseModel(listResponseModel, "告知单获取失败: ");
        List<String> applyNoList = listResponseModel.getResult();
        this.handleApplyNoList(applyNoList);

        //启动工作流
        List<WorkflowResultDto> workflowResultList = this.startWorkFlow(model.getInstallUnitCreditCode(), submitType, deviceList);

        List<JgEquipTransfer> transferList = new ArrayList<>();
        List<JgEquipTransferEq> equipTransferEqList = new ArrayList<>();
        IntStream.range(0, deviceList.size()).forEach(i -> {
            Map<String, Object> obj = deviceList.get(i);
            String applyNo = applyNoList.get(i);

            JgEquipTransferEq jgEquipTransferEq = buildJgEquipTransferEq(obj, applyNo);
            JgEquipTransfer transfer = buildJgEquipTransfer(model, applyNo, reginParams, submitType, workflowResultList, i);
            transfer.setSupervisoryCode(String.valueOf(obj.get("SUPERVISORY_CODE")));
            transfer.setEquList(Objects.toString(obj.get("EQU_LIST"),""));
            transfer.setEquDefine(Objects.toString(obj.get("EQU_DEFINE"),""));
            transfer.setEquCategory(Objects.toString(obj.get("EQU_CATEGORY"),""));
            transfer.setProductName(Objects.toString(obj.get("PRODUCT_NAME"),""));
            transfer.setUseRegistCode(Objects.toString(obj.get("USE_ORG_CODE"),""));
            transfer.setUseRegistCode(Objects.toString(obj.get("USE_ORG_CODE"), ""));
            transfer.setUseInnerCode(Objects.toString(obj.get("USE_INNER_CODE"),""));
            transfer.setEquAddress(Objects.toString(obj.get("ADDRESS"),""));
            transfer.setEquCode(Objects.toString(obj.get("EQU_CODE"),""));
            transferList.add(transfer);
            equipTransferEqList.add(jgEquipTransferEq);
        });

        baseMapper.insertBatchSomeColumn(transferList);
        if (SUBMIT_TYPE_FLOW.equals(submitType)) {
            this.buildTask(transferList, workflowResultList);
        } else{
            //批量暂存
            this.saveTempTransfer(transferList);
        }

        List<JgEquipTransferEq> jgEquipTransferEqList = this.buildJgEquipTransferEqList(equipTransferEqList, transferList);
        jgEquipTransferEqMapper.insertBatchSomeColumn(jgEquipTransferEqList);
        return transferList;
    }

    /**
     * 批量暂存
     * @param transferList 移交信息
     */
    private void saveTempTransfer(List<JgEquipTransfer> transferList) {
        if (CollectionUtils.isEmpty(transferList)) {
            return;
        }

        List<TaskModelDto> taskModelDtoList = transferList.stream().map(this::buildTempTaskModelDto).collect(Collectors.toList());
        commonService.buildTaskModel(taskModelDtoList);
    }

    private TaskModelDto buildTempTaskModelDto(JgEquipTransfer item) {
        return TaskModelDto.builder()
                .model(item)
                .taskContent(String.format("来自%s【%s】的业务办理，【申请单号：%s】", item.getEquList(), Objects.toString(item.getSupervisoryCode(), ""), item.getApplyNo()))
                .taskCode(item.getApplyNo())
                .taskType(BusinessTypeEnum.JG_EQUIPMENT_HANDOVER.getCode())
                .relationId(item.getSequenceNbr()+"")
                .build();
    }

    /**
     * 上个代办改为已办
     *
     * @param transfer 设备信息
     * @return 代办信息
     */
    private TaskV2Model updateLastTodo(JgEquipTransfer transfer, FlowStatusEnum statusEnum) {
        return commonService.updateTaskModel(MapBuilder.<String, Object>create()
                .put("taskStatus", statusEnum.getCode())
                .put("taskStatusLabel", statusEnum.getName())
                .put("flowStatus", statusEnum.getCode())
                .put("flowStatusLabel", statusEnum.getName())
                .put("relationId", transfer.getInstanceId())
                .put("model",transfer)
                .build());
    }

    /**
     * 组装代办消息
     *
     * @param item              设备移交信息
     * @param workflowResultDto 工作流返回信息
     * @return 代办信息
     */
    private TaskModelDto buildTaskModelDto(JgEquipTransfer item, WorkflowResultDto workflowResultDto) {
        TaskMessageDto taskMessageDto = new TaskMessageDto();
        BeanUtil.copyProperties(item, taskMessageDto);
        return TaskModelDto.builder()
                .flowCreateDate(item.getCreateDate())
                .taskName(workflowResultDto.getNextTaskName())
                .taskCode(item.getApplyNo())
                .taskType(BusinessTypeEnum.JG_EQUIPMENT_HANDOVER.getCode())
                .taskTypeLabel(BusinessTypeEnum.JG_EQUIPMENT_HANDOVER.getName())
                .relationId(workflowResultDto.getInstanceId())
                .executeUserIds(workflowResultDto.getNextExecutorUserIds())
                .taskStatus(FlowStatusEnum.TO_BE_PROCESSED.getCode())
                .taskStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName())
                .flowStatus(FlowStatusEnum.TO_BE_PROCESSED.getCode())
                .flowCode(workflowResultDto.getNextTaskId())
                .flowStatusLabel(FlowStatusEnum.TO_BE_PROCESSED.getName())
                .taskContent(String.format("来自%s【%s】的业务办理，【申请单号：%s】", item.getEquList(), Objects.toString(item.getSupervisoryCode(), ""), item.getApplyNo()))
                .taskDesc(String.format("来自%s【%s】的业务办理，【申请单号：%s】", item.getEquList(), Objects.toString(item.getSupervisoryCode(), ""), item.getApplyNo()))
                .startUserId(item.getCreateUserId())
                .startUser(item.getCreateUserName())
                .startUserCompanyName(item.getCreateUserCompanyName())
                .startDate(item.getCreateDate())
                .model(taskMessageDto)
                .nextExecuteUser(item.getNextExecuteIds())
                .build();
    }

    /**
     * 创建新代办
     *
     * @param transfer          设备信息
     * @param workflowResultDto 工作流信息
     * @param taskV2Model       代办信息
     */
    private void createNewTodo(JgEquipTransfer transfer, WorkflowResultDto workflowResultDto, TaskV2Model taskV2Model, FlowStatusEnum statusEnum) {
        TaskMessageDto taskMessageDto = new TaskMessageDto();
        BeanUtil.copyProperties(transfer, taskMessageDto);

        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        TaskModelDto taskModelDto = TaskModelDto.builder()
                .flowCreateDate(taskV2Model.getFlowCreateDate())
                .taskName(workflowResultDto.getNextTaskName())
                .taskCode(taskV2Model.getTaskCode())
                .taskType(taskV2Model.getTaskType())
                .taskTypeLabel(taskV2Model.getTaskTypeLabel())
                .relationId(taskV2Model.getRelationId())
                .executeUserIds(workflowResultDto.getNextExecutorUserIds())
                .taskStatusLabel(statusEnum.getName())
                .flowStatus(statusEnum.getCode())
                .flowCode(workflowResultDto.getNextTaskId())
                .flowStatusLabel(statusEnum.getName())
                .taskContent(String.format("来自%s【%s】的业务办理，【申请单号：%s】", transfer.getEquList(), transfer.getSupervisoryCode(), transfer.getApplyNo()))
                .taskDesc(String.format("来自%s【%s】的业务办理，【申请单号：%s】", transfer.getEquList(), transfer.getSupervisoryCode(), transfer.getApplyNo()))
                .startUserCompanyName(reginParams.getCompany().getCompanyName())
                .startUserId(taskV2Model.getStartUserId())
                .startUser(taskV2Model.getStartUser())
                .startDate(taskV2Model.getStartDate())
                .pageType(statusEnum.getCode() == 6614 ? "edit" : "look")
                .model(taskMessageDto)
                .nextExecuteUser(workflowResultDto.getNextExecutorRoleIds())
                .build();
        commonService.buildTaskModel(Collections.singletonList(taskModelDto));
    }

    /**
     * 暂存
     *
     * @param submitType       保存或保存并提交
     * @param equipTransferDto 设备移交和设备信息
     * @param op
     * @return 设备信息
     */
    @Transactional(rollbackFor = {Exception.class, BaseException.class})
    public JgEquipTransferDto updateEquipTransfer(String submitType, JgEquipTransferDto equipTransferDto, String op) {
        if (Objects.isNull(equipTransferDto) || StringUtils.isEmpty(submitType))
            throw new IllegalArgumentException("参数不能为空");

        this.convertField(equipTransferDto);
        JgEquipTransfer transfer = this.getById(equipTransferDto.getSequenceNbr());

        if (SUBMIT_TYPE_FLOW.equals(submitType)) {
            if (!StringUtils.hasText(equipTransferDto.getInstanceId())) {
                // 发起流程
                ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
                List<ActWorkflowStartDTO> list = new ArrayList<>();
                ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                dto.setProcessDefinitionKey(EQUIP_TRANSFER_PROCESS_KEY);
                dto.setBusinessKey(equipTransferDto.getSequenceNbr().toString());
                dto.setCompleteFirstTask(Boolean.TRUE);
                dto.setNextExecuteUserCompanyCode(equipTransferDto.getInstallUnitCreditCode());
                list.add(dto);
                actWorkflowBatchDTO.setProcess(list);
                ProcessTaskDTO processTaskDTO = cmWorkflowService.startBatch(actWorkflowBatchDTO).get(0);
                // 提取节点等信息
                WorkflowResultDto workflowResultDto = commonService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO)).get(0);
                BeanUtils.copyProperties(equipTransferDto, transfer);
                if (!ObjectUtils.isEmpty(transfer.getInstanceStatus())) {
                    transfer.setInstanceStatus(transfer.getInstanceStatus() + "," + workflowResultDto.getNextExecutorRoleIds());
                } else {
                    transfer.setInstanceStatus(workflowResultDto.getNextExecutorRoleIds());
                }
                transfer.setPromoter(RequestContext.getExeUserId());
                transfer.setNextExecuteIds(String.join(",", workflowResultDto.getNextExecutorRoleIds()));
                transfer.setApplyStatus(String.valueOf(FlowStatusEnum.TO_BE_PROCESSED.getCode()));
                transfer.setNextTaskId(workflowResultDto.getNextTaskId());
                transfer.setInstanceId(workflowResultDto.getInstanceId());
                transfer.setNextExecuteUserIds(workflowResultDto.getNextExecutorUserIds());

                updateById(transfer);
                //删除暂存
                commonService.deleteTaskModel(transfer.getSequenceNbr()+"");

                // 如果为保存并提交，则创建代办
                this.buildTask(Collections.singletonList(transfer), Collections.singletonList(workflowResultDto));
            } else {
                TaskResultDTO dto = new TaskResultDTO();
                dto.setResultCode("approvalStatus");
                dto.setTaskId(transfer.getNextTaskId());
                HashMap<String, Object> commMap = new HashMap<>();
                if (transfer.getApplyStatus().equals("6614") || transfer.getApplyStatus().equals("6615")) {
                    commMap.put("approvalStatus", "提交");
                } else {
                    commMap.put("approvalStatus", op);
                }
                dto.setVariable(commMap);
                dto.setNextExecuteUserCompanyCode(transfer.getInstallUnitCreditCode());
                ProcessTaskDTO processTaskDTO = cmWorkflowService.completeOrReject(transfer.getNextTaskId(), dto, op);
                // 提取节点等信息
                WorkflowResultDto workflowResultDto = commonService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO)).get(0);
                BeanUtils.copyProperties(equipTransferDto, transfer);

                if (!ObjectUtils.isEmpty(transfer.getInstanceStatus())) {
                    transfer.setInstanceStatus(transfer.getInstanceStatus() + "," + workflowResultDto.getNextExecutorRoleIds());
                } else {
                    transfer.setInstanceStatus(workflowResultDto.getNextExecutorRoleIds());
                }
                transfer.setPromoter(RequestContext.getExeUserId());
                transfer.setNextExecuteIds(String.join(",", workflowResultDto.getNextExecutorRoleIds()));
                transfer.setApplyStatus(String.valueOf(FlowStatusEnum.TO_BE_PROCESSED.getCode()));
                transfer.setNextTaskId(workflowResultDto.getNextTaskId());
                transfer.setNextExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
                //transfer.setInstanceId(workflowResultDto.getInstanceId());

                updateById(transfer);
                // 上个代办改为已办
                TaskV2Model taskV2Model = this.updateLastTodo(transfer, FlowStatusEnum.TO_BE_PROCESSED);
                // 创建新的代办
                this.createNewTodo(transfer, workflowResultDto, taskV2Model, FlowStatusEnum.TO_BE_PROCESSED);
            }
        } else {
            JgEquipTransfer equipTransfer = new JgEquipTransfer();
            BeanUtils.copyProperties(equipTransferDto, equipTransfer);
            updateById(equipTransfer);
        }
        return equipTransferDto;
    }

    /**
     * 通过和驳回
     *
     * @param jgEquipTransferDto 设备信息
     * @param op                 通过或驳回
     */
    public void accept(JgEquipTransferDto jgEquipTransferDto, String op) {
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        JgEquipTransfer jgEquipTransfer = baseMapper.selectById(jgEquipTransferDto.getSequenceNbr());

        TaskResultDTO workDto = new TaskResultDTO();
        workDto.setResultCode("approvalStatus");
        workDto.setTaskId(jgEquipTransfer.getNextTaskId());
        HashMap<String, Object> commMap = new HashMap<>();
        if (jgEquipTransfer.getApplyStatus().equals("6614") || jgEquipTransfer.getApplyStatus().equals("6615")) {
            commMap.put("approvalStatus", "提交");
        } else {
            commMap.put("approvalStatus", op);
        }
        workDto.setNextExecuteUserCompanyCode("1".equals(op) ? jgEquipTransfer.getUseUnitCreditCode() : jgEquipTransfer.getInstallUnitCreditCode());
        workDto.setVariable(commMap);
        workDto.setComment(jgEquipTransferDto.getProcessAdvice());
        ProcessTaskDTO processTaskDTO = cmWorkflowService.completeOrReject(jgEquipTransfer.getNextTaskId(), workDto, op);
        // 提取节点等信息
        WorkflowResultDto workflowResultDto = commonService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO)).get(0);
        jgEquipTransfer.setPromoter(reginParams.getUserModel().getUserId());
        jgEquipTransfer.setProcessAdvice(jgEquipTransferDto.getProcessAdvice());
        JgEquipTransferEq jgEquipTransferEq = jgEquipTransferEqMapper.selectOne(Wrappers.<JgEquipTransferEq>lambdaQuery().select(JgEquipTransferEq::getEquId)
                .eq(JgEquipTransferEq::getEquipTransferId, jgEquipTransferDto.getSequenceNbr()));

        TaskV2Model taskV2Model;
        if ("0".equals(op)) {
            if (StringUtils.isEmpty(workflowResultDto.getNextExecutorRoleIds())) {
                jgEquipTransfer.setApplyStatus(String.valueOf(FlowStatusEnum.TO_BE_FINISHED.getCode()));
                jgEquipTransfer.setPromoter("");
                jgEquipTransfer.setAcceptDate(new Date());
                if (jgEquipTransferEq != null) {
                    Map<String, Map<String, Object>> resultMap = MapBuilder.<String, Map<String, Object>>create()
                            .put(jgEquipTransferEq.getEquId(), MapBuilder.<String, Object>create()
                                    .put("USC_UNIT_NAME", jgEquipTransfer.getInstallUnitName())
                                    .put("USC_UNIT_CREDIT_CODE", jgEquipTransfer.getInstallUnitCreditCode())
                                    .build())
                            .build();

                    tzsServiceFeignClient.commonUpdateEsDataByIds(resultMap);
                }
                // 上个代办改为已办
                this.updateLastTodo(jgEquipTransfer, FlowStatusEnum.TO_BE_FINISHED);
            } else {
                jgEquipTransfer.setNextExecuteIds(workflowResultDto.getNextExecutorRoleIds());
                if (!ObjectUtils.isEmpty(jgEquipTransfer.getInstanceStatus())) {
                    jgEquipTransfer.setInstanceStatus(jgEquipTransfer.getInstanceStatus() + "," + workflowResultDto.getNextExecutorRoleIds());
                } else {
                    jgEquipTransfer.setInstanceStatus(workflowResultDto.getNextExecutorRoleIds());
                }
                jgEquipTransfer.setPromoter(RequestContext.getExeUserId());
                jgEquipTransfer.setApplyStatus(String.valueOf(FlowStatusEnum.TO_BE_PROCESSED.getCode()));
                jgEquipTransfer.setNextTaskId(workflowResultDto.getNextTaskId());
                jgEquipTransfer.setInstanceId(workflowResultDto.getInstanceId());
                // 上个代办改为已办
                taskV2Model = this.updateLastTodo(jgEquipTransfer, FlowStatusEnum.TO_BE_FINISHED);
                // 创建新的代办
                this.createNewTodo(jgEquipTransfer, workflowResultDto, taskV2Model, FlowStatusEnum.TO_BE_PROCESSED);
            }
        } else {
            //驳回
            jgEquipTransfer.setPromoter("");
            jgEquipTransfer.setApplyStatus(String.valueOf(FlowStatusEnum.REJECTED.getCode()));
            jgEquipTransfer.setSupervisoryCode(jgEquipTransferDto.getSupervisoryCode());
            jgEquipTransfer.setEquList(jgEquipTransferDto.getEquList());
            jgEquipTransfer.setNextTaskId(workflowResultDto.getNextTaskId());
            jgEquipTransfer.setNextExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
            //jgEquipTransfer.setInstanceId(workflowResultDto.getInstanceId());
            // 上个代办改为驳回
            taskV2Model = this.updateLastTodo(jgEquipTransfer, FlowStatusEnum.REJECTED);
            this.createNewTodo(jgEquipTransfer, workflowResultDto, taskV2Model, FlowStatusEnum.REJECTED);
        }
        updateById(jgEquipTransfer);
    }

    /**
     * 撤回操作
     *
     * @param equipTransferInfo 设备移交信息
     */
    public void cancel(JgEquipTransferDto equipTransferInfo) {
        // 查询装备移交信息
        JgEquipTransfer equipTransfer = baseMapper.selectById(equipTransferInfo.getSequenceNbr());
        if (equipTransfer != null) {
            // 回滚工作流
            ProcessTaskDTO processTaskDTO = cmWorkflowService.rollBack(equipTransferInfo.getInstanceId());
            WorkflowResultDto workflowResultDto = commonService.buildWorkFlowInfo(Collections.singletonList(processTaskDTO)).get(0);
            equipTransfer.setPromoter("");
            equipTransfer.setNextExecuteIds(workflowResultDto.getNextExecutorRoleIds());
            equipTransfer.setNextExecuteUserIds(workflowResultDto.getNextExecutorUserIds());
            equipTransfer.setApplyStatus(String.valueOf(FlowStatusEnum.ROLLBACK.getCode()));
            equipTransfer.setNextTaskId(workflowResultDto.getNextTaskId());
            baseMapper.updateById(equipTransfer);
            JSONObject jsonObject = JSON.parseObject(JSON.toJSONString(equipTransfer));
            jsonObject.put("nextExecuteUser", equipTransfer.getNextExecuteIds());
            jsonObject.put("taskType", BusinessTypeEnum.JG_EQUIPMENT_HANDOVER.getCode());
            jsonObject.put("flowStatus", FlowStatusEnum.ROLLBACK.getCode());
            jsonObject.put("flowStatusLabel", FlowStatusEnum.ROLLBACK.getName());
            commonService.rollbackTask(equipTransfer.getInstanceId(), jsonObject);
        }
    }
    private String getStringFromMap(Map<String, Object> map, String key) {
        return map.getOrDefault(key, "").toString();
    }

    @Override
    public Page<JgEquipTransferDto> queryForJgEquipTransferPage(Page<JgEquipTransferDto> page, JgEquipTransferDto dto, ReginParams reginParams) {
        CompanyBo company = reginParams.getCompany();
        Map<String, Object> companyTypeMap = jrmInstallationNoticeService.getCompanyType();

        String companyLevel = getStringFromMap(companyTypeMap, "companyLevel");
        String companyType = getStringFromMap(companyTypeMap, "companyType");

        if ("company".equals(companyLevel) && companyType != null) {
            if (companyType.contains("use")) {
                dto.setUseUnitCodeFilter(company.getCompanyCode());
            }
            if (companyType.contains("construction")) {
                dto.setInstallUnitCodeFilter(company.getCompanyCode());
            }
        }
        Page<JgEquipTransferDto> equipTransferPage = this.baseMapper.queryForPage(page, dto, reginParams.getUserModel().getUserId());
        Page<JgEquipTransferDto> equipTransferDtoPage = new Page<>();
        BeanUtils.copyProperties(equipTransferPage, equipTransferDtoPage, "records");
        List<JgEquipTransferDto> records = equipTransferPage.getRecords().stream().map(transfer -> {
            JgEquipTransferDto equipTransferDto = new JgEquipTransferDto();
            BeanUtils.copyProperties(transfer, equipTransferDto);
            if (Objects.nonNull(transfer.getApplyStatus())) {
                equipTransferDto.setApplyStatusDesc(FlowStatusEnum.getNameByType(Long.valueOf(transfer.getApplyStatus())));
            }
            return equipTransferDto;
        }).collect(Collectors.toList());
        equipTransferDtoPage.setRecords(records);

        return equipTransferDtoPage;
    }

    @Override
    public Map<String, Object> queryBySequenceNbr(Long sequenceNbr) {
        JgEquipTransfer equipTransfer = baseMapper.selectById(sequenceNbr);

        if (Objects.isNull(equipTransfer))
            return null;

        String[] fields = {"productPhoto", "designDoc", "designStandard", "factoryStandard",
                "productQualityYieldProve", "insUseMaintainExplain", "inspectReport",
                "proxyStatementAttachment", "installContractAttachment"};

        List<Map<String, Object>> equipmentInfos = this.baseMapper.queryEquipInformation(sequenceNbr);
        Map<String, Object> equipMap = null;
        if (equipmentInfos != null && !equipmentInfos.isEmpty()) {
            String equId = (String) equipmentInfos.get(0).get("equId");
            if (equId != null) {
                equipMap = idxBizJgRegisterInfoService.getDetailFieldCamelCaseByRecord(equId);
            }
        }

        Map<String, Object> equipTransferInfo = createEquipTransferInfo(equipTransfer);

        handleJsonArrayFields(equipTransferInfo, fields);
        handleJsonArrayFields(equipMap, fields);

        return Stream.concat(equipTransferInfo.entrySet().stream(),
                        equipMap.entrySet().stream())
                .filter(entry -> entry.getValue() != null)
                .collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (existing, replacement) -> existing));
    }

    private void handleJsonArrayFields(Map<String, Object> map, String[] fields) {
        for (String field : fields) {
            map.computeIfPresent(field, (key, value) -> JSON.parseArray(value.toString()));
        }
    }

    /**
     * 插入代办
     */
    private void buildTask(List<JgEquipTransfer> list, List<WorkflowResultDto> workflowResultList) {
        if (CollectionUtils.isEmpty(list) || CollectionUtils.isEmpty(workflowResultList)) {
            return;
        }

        List<TaskModelDto> taskModelDtoList = list.stream().map(item ->
                this.buildTaskModelDto(item, workflowResultList.get(0))).collect(Collectors.toList());
        commonService.buildTaskModel(taskModelDtoList);
    }

    /**
     * 启动工作流
     *
     * @param submitType 提交类型
     * @param deviceList 设备列表
     * @return 工作流信息
     */
    private List<WorkflowResultDto> startWorkFlow(String receiveOrgCode, String submitType, List<Map<String, Object>> deviceList) {
        if (!SUBMIT_TYPE_FLOW.equals(submitType)) {
            return new ArrayList<>();
        }
        ActWorkflowBatchDTO actWorkflowBatchDTO = new ActWorkflowBatchDTO();
        List<ActWorkflowStartDTO> list = deviceList.stream()
                .map(item -> {
                    ActWorkflowStartDTO dto = new ActWorkflowStartDTO();
                    dto.setProcessDefinitionKey(EQUIP_TRANSFER_PROCESS_KEY);
                    dto.setBusinessKey(item.get("SEQUENCE_NBR").toString());
                    dto.setCompleteFirstTask(Boolean.TRUE);
                    dto.setNextExecuteUserCompanyCode(receiveOrgCode);
                    return dto;
                })
                .collect(Collectors.toList());

        actWorkflowBatchDTO.setProcess(list);
        List<ProcessTaskDTO> processTaskDTOS = cmWorkflowService.startBatch(actWorkflowBatchDTO);
        // 组装工作流返回的数据
        return commonService.buildWorkFlowInfo(processTaskDTOS);
    }

    /**
     * 字段拼接
     *
     * @param model 设备信息
     */
    private void convertField(JgEquipTransferDto model) {
        if (null == model)
            return;
        String installUnitId = model.getInstallUnitCreditCode();
        if (!ObjectUtils.isEmpty(installUnitId)) {
            String[] installUnitIdList = installUnitId.split("_");
            if (installUnitIdList.length > 1) {
                model.setInstallUnitCreditCode(installUnitIdList[0]);
                model.setInstallUnitName(installUnitIdList[1]);
            }
        }
    }

    private JgEquipTransferEq buildJgEquipTransferEq(Map<String, Object> obj, String applyNo) {
        JgEquipTransferEq jgEquipTransferEq = new JgEquipTransferEq();
        jgEquipTransferEq.setEquId(String.valueOf(obj.get("SEQUENCE_NBR")));
        jgEquipTransferEq.setEquipTransferId(applyNo);
        return jgEquipTransferEq;
    }

    private JgEquipTransfer buildJgEquipTransfer(JgEquipTransferDto model, String applyNo, ReginParams reginParams,
                                                 String submitType, List<WorkflowResultDto> workflowResultList, int i) {
        JgEquipTransfer dto = new JgEquipTransfer();
        BeanUtils.copyProperties(model, dto);
        dto.setApplyNo(applyNo);
        dto.setApplyDate(new Date());
        dto.setCreateUserName(reginParams.getUserModel().getRealName());
        dto.setCreateUserId(reginParams.getUserModel().getUserId());
        dto.setCreateUserCompanyName(reginParams.getCompany().getCompanyName());

        if (SUBMIT_TYPE_FLOW.equals(submitType)) {
            WorkflowResultDto workflowResult = workflowResultList.get(i);
            dto.setNextExecuteIds(workflowResult.getNextExecutorRoleIds());
            dto.setInstanceStatus(workflowResult.getNextExecutorRoleIds() + "," + workflowResult.getExecutorRoleIds());
            dto.setPromoter(reginParams.getUserModel().getUserId());
            dto.setNextTaskId(workflowResult.getNextTaskId());
            dto.setNextExecuteUserIds(workflowResult.getNextExecutorUserIds());
        }else{
            dto.setNextExecuteUserIds(RequestContext.getExeUserId());
        }
        if (!CollectionUtils.isEmpty(workflowResultList)) {
            dto.setInstanceId(workflowResultList.get(i).getInstanceId());
            dto.setApplyStatus(String.valueOf(FlowStatusEnum.TO_BE_PROCESSED.getCode()));
        } else {
            dto.setApplyStatus(String.valueOf(FlowStatusEnum.TO_BE_SUBMITTED.getCode()));
        }
        return dto;
    }

    private List<JgEquipTransferEq> buildJgEquipTransferEqList(List<JgEquipTransferEq> equipTransferEqList, List<JgEquipTransfer> list) {
        return equipTransferEqList.stream()
                .map(transferEq -> {
                    Long sequenceNbr = list.stream()
                            .filter(transfer -> transferEq.getEquipTransferId().equals(transfer.getApplyNo()))
                            .findFirst()
                            .map(JgEquipTransfer::getSequenceNbr)
                            .orElse(null);
                    return transferEq.setEquipTransferId(String.valueOf(sequenceNbr));
                })
                .collect(Collectors.toList());
    }

    private void handleResponseModel(ResponseModel<List<String>> listResponseModel, String errorMessagePrefix) {
        if (listResponseModel == null || listResponseModel.getStatus() != HttpStatus.OK.value()) {
            log.error(errorMessagePrefix + "{}", listResponseModel != null ? listResponseModel.getMessage() : "null");
            throw new BadRequest("告知单生成失败！");
        }
    }

    private void handleApplyNoList(List<String> applyNoList) {
        if (CollectionUtils.isEmpty(applyNoList)) {
            log.error("告知单返回为空");
            throw new BadRequest("告知单生成失败！");
        }
    }

    private Map<String, Object> createEquipTransferInfo(JgEquipTransfer equipTransfer) {
        Map<String, Object> equipTransferInfo = new HashMap<>(BeanUtil.beanToMap(equipTransfer));
        equipTransferInfo.put("installUnitCreditCode", equipTransfer.getInstallUnitCreditCode() + "_" + equipTransfer.getInstallUnitName());
        return equipTransferInfo;
    }

    @Transactional(rollbackFor = Exception.class)
    public Boolean deleteForBatch(Long[] ids) {
        Collection<JgEquipTransfer> jgEquipTransfers = this.listByIds(Arrays.asList(ids));
        for (JgEquipTransfer notice : jgEquipTransfers) {
            notice.setIsDelete(true);
            commonService.deleteTaskModel(String.valueOf(notice.getSequenceNbr()));
        }
        return this.updateBatchById(jgEquipTransfers);
    }
}