package com.yeejoin.amos.boot.module.ugp.api.Enum;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.xmlbeans.impl.xb.xsdschema.Public;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Getter
@AllArgsConstructor
public enum CompanyTypeEnum {

    建设单位("CONSTRUCTION","建设单位","使用单位"),
    安装单位("INSTALL","安装单位","安装改造维修单位"),
    设计单位("DESIGN","设计单位","设计单位"),
    监检机构("MONITORING","检验检测单位","检验检测机构"),
    监理单位("SUPERVISOR","监理单位","监理单位(燃气管道)"),
    监察单位("SUPERVISION","监察单位","监察单位"),
    监管机构("SUPERVISION","监管机构","监管机构");

    String key;
    String type;
    String registerName;


    public static List<Map<String,String>> mapList = new ArrayList<>();
    public static Map<String,String> registerNameMap = new HashMap<>();
    static{
        for(CompanyTypeEnum companyTypeEnum:CompanyTypeEnum.values()){
            Map<String,String> map = new HashMap();
            map.put("name", companyTypeEnum.getType());
            map.put("id", companyTypeEnum.getKey());
            mapList.add(map);

            registerNameMap.put(companyTypeEnum.getRegisterName(),companyTypeEnum.getKey());
        }
    }
}
