package com.yeejoin.amos.boot.module.statistcs.biz.controller;

import com.yeejoin.amos.boot.biz.common.dto.CommonVideoDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.statistcs.biz.service.impl.VideoServiceImpl;
import com.yeejoin.amos.boot.module.statistics.api.dto.UnitVideoDto;
import com.yeejoin.amos.boot.module.statistics.api.vo.TreeNodeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.exception.instance.BadRequest;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * @author suhuiguang
 */
@RestController
@Api(tags = "摄像头相关api")
@RequestMapping("/video")
public class VideoController {

    private VideoServiceImpl videoService;

    public VideoController(VideoServiceImpl videoService) {
        this.videoService = videoService;
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "区域、单位、摄像头3级树接口", httpMethod = "POST")
    @PostMapping(value = "/tree")
    public ResponseModel<List<TreeNodeVo>> getVideoTree(@Validated @RequestBody DPFilterParamDto dpFilterParamDto, BindingResult result) {
        List<FieldError> fieldErrors = result.getFieldErrors();
        if (!fieldErrors.isEmpty()) {
            throw new BadRequest(fieldErrors.get(0).getDefaultMessage());
        }
        List<TreeNodeVo> re = videoService.getVideoTree(dpFilterParamDto);
        return ResponseHelper.buildResponse(re);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询指定区域下的单位列表接口，带摄像头数量统计-不分页", httpMethod = "GET")
    @GetMapping(value = "/countByUnit")
    public ResponseModel<List<UnitVideoDto>> getUnitList(@RequestParam(value = "code") String regionCode) {
        List<UnitVideoDto> re = videoService.getUnitList(regionCode);
        return ResponseHelper.buildResponse(re);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "查询指定单位下的摄像头列表接口-不分页", httpMethod = "GET")
    @GetMapping(value = "/list")
    public ResponseModel<List<CommonVideoDto>> getVideoList(@RequestParam(value = "code") String useUnitCode, @RequestParam(value = "regionCode") String regionCode) {
        List<CommonVideoDto> re = videoService.getVideoList(useUnitCode, regionCode);
        return ResponseHelper.buildResponse(re);
    }
}
