package com.yeejoin.amos.latentdanger.core.enums;

import org.apache.commons.lang.enums.ValuedEnum;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * 操作枚举
 * 
 * @author as-youjun
 *
 */
@SuppressWarnings("all")
public final class QueryOperatorEnum extends ValuedEnum {

	private static final long serialVersionUID = -375127751242109017L;
	public static final int LESS_VALUE = 1; // 小于
	public static final int BIGGER_VALUE = 2; // 大于
	public static final int EQUAL_VALUE = 3; // 等于
	public static final int LESS_EQUAL_VALUE = 4; // 小于等于
	public static final int BIGGER_EQUAL_VALUE = 5; // 大于等于
	public static final int NOT_EQUAL_VALUE = 6; // 不等于
	public static final int IN_VALUE = 7; // 包含
	public static final int LIKE_VALUE = 8; // like
	public static final int OR_VALUE = 9; // 或者
	public static final int ORDER_VALUE = 10; // 排序
	public static final int NOT_IN_VALUE = 11; // 不包含
	public static final int IS_VALUE= 12; //是

	public static final QueryOperatorEnum LESS = new QueryOperatorEnum("LESS", 1, "<");
	public static final QueryOperatorEnum BIGGER = new QueryOperatorEnum("BIGGER", 2, ">");
	public static final QueryOperatorEnum EQUAL = new QueryOperatorEnum("EQUAL", 3, "=");
	public static final QueryOperatorEnum LESS_EQUAL = new QueryOperatorEnum("LESS_EQUAL", 4, "<=");
	public static final QueryOperatorEnum BIGGER_EQUAL = new QueryOperatorEnum("BIGGER_EQUAL", 5, ">=");
	public static final QueryOperatorEnum NOT_EQUAL = new QueryOperatorEnum("NOT_EQUAL", 6, "<>");
	public static final QueryOperatorEnum IN = new QueryOperatorEnum("IN", 7, "IN");
	public static final QueryOperatorEnum LIKE = new QueryOperatorEnum("LIKE", 8, "LIKE");
	public static final QueryOperatorEnum OR = new QueryOperatorEnum("OR", 9, "OR");
	public static final QueryOperatorEnum ORDER_BY = new QueryOperatorEnum("ORDER BY", 10, "ORDER BY");
	public static final QueryOperatorEnum NOT_IN = new QueryOperatorEnum("NOT IN", 11, "NOT IN");
	public static final QueryOperatorEnum IS = new QueryOperatorEnum("IS", 12, "IS");

	public String condition;

	public String getCondition() {
		return condition;
	}

	public void setCondition(String condition) {
		this.condition = condition;
	}

	protected QueryOperatorEnum(String arg0, int arg1, String condition) {
		super(arg0, arg1);
		this.condition = condition;

	}

	public static QueryOperatorEnum getEnum(String name) {
		try {
			return ((QueryOperatorEnum) getEnum(QueryOperatorEnum.class, name));
		} catch (Exception ex) {
			return null;
		}
	}

	public static QueryOperatorEnum getEnum(int name) {
		try {
			return ((QueryOperatorEnum) getEnum(QueryOperatorEnum.class, name));
		} catch (Exception ex) {
			return null;
		}
	}

	public static Map getMap() {
		try {
			return getEnumMap(QueryOperatorEnum.class);
		} catch (Exception ex) {
			return null;
		}
	}

	public static List getList() {
		try {
			return getEnumList(QueryOperatorEnum.class);
		} catch (Exception ex) {
			return null;
		}
	}

	public static Iterator iterator() {
		try {
			return iterator(QueryOperatorEnum.class);
		} catch (Exception ex) {
			return null;
		}
	}

}
