package com.yeejoin.amos.knowledgebase.face.service;


import com.yeejoin.amos.knowledgebase.face.model.KnowledgeTagGroupRefModel;
import com.yeejoin.amos.knowledgebase.face.orm.dao.TagGroupRefMapper;
import com.yeejoin.amos.knowledgebase.face.orm.entity.KnowledgeTagGroupRef;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.typroject.tyboot.core.foundation.utils.Bean;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;


/**
 * <p>
 * 标签分组 服务类
 * </p>
 *
 * @author 子杨
 * @since 2020-08-05
 */
@Component
public class TagGroupRefService extends BaseService<KnowledgeTagGroupRefModel, KnowledgeTagGroupRef, TagGroupRefMapper> {

    //创建某个标签的分组关系
    @Transactional
    public void createGroupRefForTag(Long tagSeq, List<Long> tagGroupSeqs) {
        for (Long groupSeq : tagGroupSeqs) {
            KnowledgeTagGroupRefModel refModel = new KnowledgeTagGroupRefModel();
            refModel.setTagSeq(tagSeq);
            refModel.setGroupSeq(groupSeq);
            this.createWithModel(refModel);
        }
    }

    public void deleteRefsByTagSeq(Long tagSeq) {
        List<KnowledgeTagGroupRefModel> oldRefs = this.queryListByTagSeq(tagSeq);
        for (KnowledgeTagGroupRefModel oldRef : oldRefs) {
            this.deleteBySeq(oldRef.getSequenceNbr());
        }
    }

    //根据标签id查询关系数据
    public List<KnowledgeTagGroupRefModel> queryListByTagSeq(Long tagSeq) {
        return this.queryForList(null, false, tagSeq);
    }

    //根据分组id列表查询所有的标签ID
    public List queryTagSeqListByGroupSeqList(List<Long> groupSeqList) {
        List<KnowledgeTagGroupRefModel> refModelList = queryListByGroupSeqList(groupSeqList);
        Set<Object> tagSeq = Bean.listToMap(refModelList, "tagSeq", KnowledgeTagGroupRefModel.class).keySet();
        return new ArrayList(tagSeq);
    }

    //根据分组id列表查询所有的关系
    private List<KnowledgeTagGroupRefModel> queryListByGroupSeqList(@Condition(Operator.in) List<Long> groupSeq) {
        return this.queryForList(null, false, groupSeq);
    }
}
