package com.yeejoin.amos.supervision.business.dao.mapper;

import java.util.HashMap;
import java.util.List;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.biz.common.annotations.DataAuth;
import org.apache.ibatis.annotations.Param;

import com.yeejoin.amos.supervision.business.param.PlanInfoPageParam;
import com.yeejoin.amos.supervision.dao.entity.Plan;

public interface PlanMapper extends BaseMapper<Plan>, com.yeejoin.amos.supervision.business.dao.mapper.BaseMapper {

	void saveAs(String id);
	
	void updPlanStatusOrGenDate(HashMap<String,Object> id);

	/**
	 * 根据路线id获取关联的计划
	 * 
	 * @param routeId
	 * @return
	 */
	List<Plan> getPlanByRouteId(@Param(value = "routeId") Long routeId);
	/**
	 * 统计巡检计划数量
	 * @param param
	 * @return
	 */
	@DataAuth(interfacePath = "supervision/api/plan/list")
	long countPlanInfoData(PlanInfoPageParam param);
	/**
	 * 按照查询巡检计划概要列表
	 * @param param
	 * @return
	 */
	@DataAuth(interfacePath = "supervision/api/plan/list")
	List<HashMap<String, Object>> getPlanInfo(PlanInfoPageParam param);
	/**
	 * 按照查询巡检计划概不分页
	 * @param param
	 * @return
	 */
	List<HashMap<String, Object>> getPlanInfoNoPage(PlanInfoPageParam param);

	/**
	 *	 查询计划列表
	 * @param loginOrgCode
	 * @return
	 */
	List<HashMap<String, Object>> queryPlanListByOrgCode(@Param("orgCode") String loginOrgCode);
	

	/**
	 * 初始化计划状态
	 */
	void initUpdatePlanStatus();
	
	/**
	 * 初始化计划下次执行时间
	 */
	void initUpdatePlanNextGenDate();
}
