package com.yeejoin.amos.boot.module.hygf.api.util;

import org.springframework.beans.BeanUtils;

public class BeanDtoUtils {


    /**
     * Dot ,Vo ,Entity 相互转换
     *
     * @param source      原数据
     * @param targetClass 目标类
     * @param <T>         泛型类
     * @return 转换返回值
     */
    public static <T> T convert(Object source, Class<T> targetClass) {
        // 判断source是否为空
        if (source == null) {
            return null;
        }
        // 判断targetClass是否为空
        if (targetClass == null) {
            return null;
        }
        try {
            // 创建新的对象实例
            T target = targetClass.newInstance();
            // 把原对象数据拷贝到新对象
            BeanUtils.copyProperties(source, target);
            // 返回新对象
            return target;
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}
