package com.yeejoin.amos.boot.module.hygf.biz.service.impl;

import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yeejoin.amos.boot.module.hygf.api.entity.BasicGridAcceptance;
import com.yeejoin.amos.boot.module.hygf.api.entity.FinancingInfo;
import com.yeejoin.amos.boot.module.hygf.api.mapper.FinancingInfoMapper;
import com.yeejoin.amos.boot.module.hygf.api.service.IFinancingInfoService;
import com.yeejoin.amos.boot.module.hygf.api.dto.FinancingInfoDto;
import org.springframework.beans.factory.annotation.Autowired;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.rdbms.service.BaseService;
import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.List;
import java.util.Map;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2024-04-01
 */
@Service
public class FinancingInfoServiceImpl extends BaseService<FinancingInfoDto,FinancingInfo,FinancingInfoMapper> implements IFinancingInfoService {
    /**
     * 分页查询
     */
    @Autowired
    private FinancingInfoMapper financingInfoMapper;
    @Autowired
    private WorkflowImpl workflow;


    public Page<Map<String, String>> queryForFinancingInfoPage(Page<Map<String, String>> page)   {

        PageHelper.startPage((int)page.getCurrent(),(int)page.getSize());
        List<Map<String, String>> list = financingInfoMapper.getStationFinancingInfoList();
        PageInfo<Map<String, String>> infos = new PageInfo<>(list);
        page.setRecords(list);
        page.setTotal(infos.getTotal());
        return page;
    }

    /**
     * 列表查询 示例
     */
    public List<FinancingInfoDto> queryForFinancingInfoList()   {
        return this.queryForList("" , false);
    }

    public FinancingInfoDto saveModel(FinancingInfoDto model) {
        this.createWithModel(model);
        return null;
    }
}