package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.utils.DateUtils;
import com.yeejoin.amos.boot.module.jxiop.biz.Enum.WarningPeriodEnum;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizFanHealthLevel;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.IdxBizPvHealthLevel;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizFanHealthLevelMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizPvHealthIndexMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.mapper2.IdxBizPvHealthLevelMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.tdMapper2.FanHealthIndexMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.tdMapper2.PvHealthIndexMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.FanHealthIndex;
import com.yeejoin.amos.boot.module.jxiop.biz.tdengine.PvHealthIndex;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


@Slf4j
@Service
@EnableScheduling
public class TdengineTimeServiceImpl {

    @Autowired
    private FanHealthIndexMapper fanHealthIndexMapper;

    @Autowired
    private IdxBizPvHealthIndexMapper idxFanHealthIndexMapper;


    @Autowired
    private PvHealthIndexMapper pvHealthIndexMapper;

    @Autowired
    private IdxBizFanHealthLevelMapper idxBizFanHealthLevelMapper;

    @Autowired
    private IdxBizPvHealthLevelMapper idxBizPvHealthLevelMapper;

    @Value("${openHealth:true}")
    Boolean openHealth;

    /**
     * 风电 - 按时刻生成子系统、设备、场站、区域 数据
     */
    public void insertMomentData(String recDate) throws ParseException {
        //s 489分钟 为  8小时  +  19分钟
        String startTime = DateUtils.dateFormat(DateUtils.dateAddMinutes(new Date(), -489), DateUtils.DATE_TIME_PATTERN);
        // 子系统
        List<IdxBizFanHealthLevel> levelListZxt = idxBizFanHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizFanHealthLevel>().eq(IdxBizFanHealthLevel::getAnalysisObjType, "子系统").last("limit 4"));
        List<FanHealthIndex> fanHealthIndicesZxt = fanHealthIndexMapper.getInfoListByGroupByZxtFan(startTime, "fan_health_index_moment", "测点");
        saveBatchFan(fanHealthIndicesZxt, "fan_health_index_moment", recDate, WarningPeriodEnum.MINUTES.getName(), levelListZxt);
        // 设备
        List<IdxBizFanHealthLevel> levelListSb = idxBizFanHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizFanHealthLevel>().eq(IdxBizFanHealthLevel::getAnalysisObjType, "设备").last("limit 4"));
        List<FanHealthIndex> fanHealthIndicesSb = fanHealthIndexMapper.getInfoListByGroupBySbFan(startTime, "fan_health_index_moment", "子系统");
        saveBatchFan(fanHealthIndicesSb, "fan_health_index_moment", recDate, WarningPeriodEnum.MINUTES.getName(), levelListSb);
        // 场站
        List<IdxBizFanHealthLevel> levelListCz = idxBizFanHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizFanHealthLevel>().eq(IdxBizFanHealthLevel::getAnalysisObjType, "场站").last("limit 4"));
        List<FanHealthIndex> fanHealthIndicesCz = fanHealthIndexMapper.getInfoListByGroupByCzFan(startTime, "fan_health_index_moment", "设备");
        saveBatchFan(fanHealthIndicesCz, "fan_health_index_moment", recDate, WarningPeriodEnum.MINUTES.getName(), levelListCz);
        // 区域
        List<IdxBizFanHealthLevel> levelListQy = idxBizFanHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizFanHealthLevel>().eq(IdxBizFanHealthLevel::getAnalysisObjType, "片区").last("limit 4"));
        List<FanHealthIndex> fanHealthIndicesQy = fanHealthIndexMapper.getInfoListByGroupByQyFan(startTime, "fan_health_index_moment", "场站");
        saveBatchFan(fanHealthIndicesQy, "fan_health_index_moment", recDate, WarningPeriodEnum.MINUTES.getName(), levelListQy);
        // 全域【所有 / 全国】
        List<IdxBizFanHealthLevel> levelListQg = idxBizFanHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizFanHealthLevel>().eq(IdxBizFanHealthLevel::getAnalysisObjType, "全域").last("limit 4"));
        List<FanHealthIndex> fanHealthIndicesQg = fanHealthIndexMapper.getInfoListByGroupByQgFan(startTime, "fan_health_index_moment", "片区");
        saveBatchFan(fanHealthIndicesQg, "fan_health_index_moment", recDate, WarningPeriodEnum.MINUTES.getName(), levelListQg);

    }


    /**
     * 风电 - 按小时生成测点、子系统、设备、场站、区域 数据
     */
    @Scheduled(cron = "0 0 0/1 * * ? ")
    public void insertHourData() throws ParseException {
        if (!openHealth) {
            return;
        }
        idxFanHealthIndexMapper.deleteAllDataByTableName("fan_health_index_latest_data", WarningPeriodEnum.HOUR.getName());
        String recDate = DateUtil.format(new Date(), "yyyy-MM-dd HH:00:00");
        // 8小时 + 59分钟
        String startTime = DateUtils.dateFormat(DateUtils.dateAddMinutes(new Date(), -541), DateUtils.DATE_TIME_PATTERN);
        // 测点
        List<IdxBizFanHealthLevel> levelList = idxBizFanHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizFanHealthLevel>().eq(IdxBizFanHealthLevel::getAnalysisObjType, "测点").last("limit 4"));
        List<FanHealthIndex> fanHealthIndices = fanHealthIndexMapper.getInfoListByGroupByCdFan(startTime, "fan_health_index_moment", "测点");
        saveBatchFan(fanHealthIndices, "fan_health_index_hour", recDate, WarningPeriodEnum.HOUR.getName(), levelList);
        // 子系统
        List<IdxBizFanHealthLevel> levelListZxt = idxBizFanHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizFanHealthLevel>().eq(IdxBizFanHealthLevel::getAnalysisObjType, "子系统").last("limit 4"));
        List<FanHealthIndex> fanHealthIndicesZxt = fanHealthIndexMapper.getInfoListByGroupByZxtFan(startTime, "fan_health_index_moment", "测点");
        saveBatchFan(fanHealthIndicesZxt, "fan_health_index_hour", recDate, WarningPeriodEnum.HOUR.getName(), levelListZxt);
        // 设备
        List<IdxBizFanHealthLevel> levelListSb = idxBizFanHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizFanHealthLevel>().eq(IdxBizFanHealthLevel::getAnalysisObjType, "设备").last("limit 4"));
        List<FanHealthIndex> fanHealthIndicesSb = fanHealthIndexMapper.getInfoListByGroupBySbFan(startTime, "fan_health_index_moment", "子系统");
        saveBatchFan(fanHealthIndicesSb, "fan_health_index_hour", recDate,  WarningPeriodEnum.HOUR.getName(), levelListSb);
        // 场站
        List<IdxBizFanHealthLevel> levelListCz = idxBizFanHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizFanHealthLevel>().eq(IdxBizFanHealthLevel::getAnalysisObjType, "场站").last("limit 4"));
        List<FanHealthIndex> fanHealthIndicesCz = fanHealthIndexMapper.getInfoListByGroupByCzFan(startTime, "fan_health_index_moment", "设备");
        saveBatchFan(fanHealthIndicesCz, "fan_health_index_hour", recDate,  WarningPeriodEnum.HOUR.getName(), levelListCz);
        // 区域
        List<IdxBizFanHealthLevel> levelListQy = idxBizFanHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizFanHealthLevel>().eq(IdxBizFanHealthLevel::getAnalysisObjType, "片区").last("limit 4"));
        List<FanHealthIndex> fanHealthIndicesQy = fanHealthIndexMapper.getInfoListByGroupByQyFan(startTime, "fan_health_index_moment", "场站");
        saveBatchFan(fanHealthIndicesQy, "fan_health_index_hour", recDate,  WarningPeriodEnum.HOUR.getName(), levelListQy);

        // 全域【所有 / 全国】
        List<IdxBizFanHealthLevel> levelListQg = idxBizFanHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizFanHealthLevel>().eq(IdxBizFanHealthLevel::getAnalysisObjType, "全域").last("limit 4"));
        List<FanHealthIndex> fanHealthIndicesQg = fanHealthIndexMapper.getInfoListByGroupByQgFan(startTime, "fan_health_index_moment", "片区");
        saveBatchFan(fanHealthIndicesQg, "fan_health_index_hour", recDate,  WarningPeriodEnum.HOUR.getName(), levelListQg);
    }

    /**
     * 风电 - 按天生成测点、子系统、设备、场站、区域 数据
     */
    @Scheduled(cron = "0 05 0 1/1 * ? ")
    public void insertDayData() throws ParseException {
        if (!openHealth) {
            return;
        }
        idxFanHealthIndexMapper.deleteAllDataByTableName("fan_health_index_latest_data", WarningPeriodEnum.DAY.getName());
        Date recOriginalDate = new Date();
        recOriginalDate  = DateUtil.offsetDay(recOriginalDate, -1);
        String recDate = DateUtil.format(recOriginalDate, "yyyy-MM-dd");
        String startTime = DateUtils.dateFormat(DateUtils.dateAddHours(new Date(), -32), DateUtils.DATE_TIME_PATTERN);
        List<IdxBizFanHealthLevel> levelList = idxBizFanHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizFanHealthLevel>().eq(IdxBizFanHealthLevel::getAnalysisObjType, "测点").last("limit 4"));
        List<FanHealthIndex> fanHealthIndices = fanHealthIndexMapper.getInfoListByGroupByCdFan(startTime, "fan_health_index_hour", "测点");
        saveBatchFan(fanHealthIndices, "fan_health_index_day", recDate, WarningPeriodEnum.DAY.getName(), levelList);

        // 子系统
        List<IdxBizFanHealthLevel> levelListZxt = idxBizFanHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizFanHealthLevel>().eq(IdxBizFanHealthLevel::getAnalysisObjType, "子系统").last("limit 4"));
        List<FanHealthIndex> fanHealthIndicesZxt = fanHealthIndexMapper.getInfoListByGroupByZxtFan(startTime, "fan_health_index_hour", "测点");
        saveBatchFan(fanHealthIndicesZxt, "fan_health_index_day", recDate, WarningPeriodEnum.DAY.getName(), levelListZxt);
        // 设备
        List<IdxBizFanHealthLevel> levelListSb = idxBizFanHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizFanHealthLevel>().eq(IdxBizFanHealthLevel::getAnalysisObjType, "设备").last("limit 4"));
        List<FanHealthIndex> fanHealthIndicesSb = fanHealthIndexMapper.getInfoListByGroupBySbFan(startTime, "fan_health_index_hour", "子系统");
        saveBatchFan(fanHealthIndicesSb, "fan_health_index_day", recDate, WarningPeriodEnum.DAY.getName(), levelListSb);
        // 场站
        List<IdxBizFanHealthLevel> levelListCz = idxBizFanHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizFanHealthLevel>().eq(IdxBizFanHealthLevel::getAnalysisObjType, "场站").last("limit 4"));
        List<FanHealthIndex> fanHealthIndicesCz = fanHealthIndexMapper.getInfoListByGroupByCzFan(startTime, "fan_health_index_hour", "设备");
        saveBatchFan(fanHealthIndicesCz, "fan_health_index_day", recDate, WarningPeriodEnum.DAY.getName(), levelListCz);
        // 区域
        List<IdxBizFanHealthLevel> levelListQy = idxBizFanHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizFanHealthLevel>().eq(IdxBizFanHealthLevel::getAnalysisObjType, "片区").last("limit 4"));
        List<FanHealthIndex> fanHealthIndicesQy = fanHealthIndexMapper.getInfoListByGroupByQyFan(startTime, "fan_health_index_hour", "场站");
        saveBatchFan(fanHealthIndicesQy, "fan_health_index_day", recDate, WarningPeriodEnum.DAY.getName(), levelListQy);
        // 全域【所有 / 全国】
        List<IdxBizFanHealthLevel> levelListQg = idxBizFanHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizFanHealthLevel>().eq(IdxBizFanHealthLevel::getAnalysisObjType, "全域").last("limit 4"));
        List<FanHealthIndex> fanHealthIndicesQg = fanHealthIndexMapper.getInfoListByGroupByQgFan(startTime, "fan_health_index_hour", "片区");
        saveBatchFan(fanHealthIndicesQg, "fan_health_index_day", recDate, WarningPeriodEnum.DAY.getName(), levelListQg);
    }


    private String getHealthLevelByScore(List<IdxBizFanHealthLevel> levelList, Double healthIndex) {
        String levelDesc = "安全";
        for (IdxBizFanHealthLevel item : levelList) {
            if (item.getGroupUpperLimit() >= healthIndex && item.getGroupLowerLimit() < healthIndex) {
                levelDesc = item.getHealthLevel();
                break;
            }
        }
        return levelDesc;
    }

    private void saveBatchFan(List<FanHealthIndex> fanHealthIndices,
                              String tableName,
                              String recDate,
                              String analysisType,
                              List<IdxBizFanHealthLevel> levelList) {
        ArrayList<FanHealthIndex> newList = new ArrayList<>();
        for (int i = 0; i < fanHealthIndices.size(); i++) {
            FanHealthIndex fanHealthIndex = fanHealthIndices.get(i);
            fanHealthIndex.setRecDate(recDate);
            fanHealthIndex.setAnalysisTime(recDate);
            fanHealthIndex.setAnalysisType(analysisType);
            fanHealthIndex.setHealthLevel(getHealthLevelByScore(levelList, fanHealthIndex.getHealthIndex()));
            //分批次处理
            newList.add(fanHealthIndex);//循环将数据填入载体list
            if (500 == newList.size() || i == fanHealthIndices.size() - 1) {  //载体list达到要求,进行批量操作
                //调用批量插入
                fanHealthIndexMapper.saveBatchHealthIndexList(newList, tableName, analysisType);
                idxFanHealthIndexMapper.saveBatchHealthIndexLatestInfo(newList);
                newList.clear();//每次批量操作后,清空载体list,等待下次的数据填入
            }
        }
    }

    /**
     * 光伏 -  按时刻生成设备、子阵、场站和片区数据
     */
    public void insertMomentDataPv(String recDate) throws ParseException {
        String startTime = DateUtils.dateFormat(DateUtils.dateAddMinutes(new Date(), -489), DateUtils.DATE_TIME_PATTERN);
        // 设备
        List<IdxBizPvHealthLevel> levelListSb = idxBizPvHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizPvHealthLevel>().eq(IdxBizPvHealthLevel::getAnalysisObjType, "设备").last("limit 4"));
        List<PvHealthIndex> fanHealthIndicesSb = pvHealthIndexMapper.getInfoListByGroupBySbPv(startTime, "pv_health_index_moment", "测点");
        saveBatchPv(fanHealthIndicesSb, "pv_health_index_moment", recDate, WarningPeriodEnum.MINUTES.getName(), levelListSb);
        // 子阵
        List<IdxBizPvHealthLevel> levelListZz = idxBizPvHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizPvHealthLevel>().eq(IdxBizPvHealthLevel::getAnalysisObjType, "子阵").last("limit 4"));
        List<PvHealthIndex> fanHealthIndicesZz = pvHealthIndexMapper.getInfoListByGroupByZzPv(startTime, "pv_health_index_moment", "设备");
        saveBatchPv(fanHealthIndicesZz, "pv_health_index_moment", recDate, WarningPeriodEnum.MINUTES.getName(), levelListZz);
        // 场站
        List<IdxBizPvHealthLevel> levelListCz = idxBizPvHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizPvHealthLevel>().eq(IdxBizPvHealthLevel::getAnalysisObjType, "场站").last("limit 4"));
        List<PvHealthIndex> fanHealthIndicesCz = pvHealthIndexMapper.getInfoListByGroupByCzPv(startTime, "pv_health_index_moment", "子阵");
        saveBatchPv(fanHealthIndicesCz, "pv_health_index_moment", recDate, WarningPeriodEnum.MINUTES.getName(), levelListCz);
        // 片区
        List<IdxBizPvHealthLevel> levelListQy = idxBizPvHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizPvHealthLevel>().eq(IdxBizPvHealthLevel::getAnalysisObjType, "片区").last("limit 4"));
        List<PvHealthIndex> fanHealthIndicesQy = pvHealthIndexMapper.getInfoListByGroupByQyPv(startTime, "pv_health_index_moment", "场站");
        saveBatchPv(fanHealthIndicesQy, "pv_health_index_moment", recDate, WarningPeriodEnum.MINUTES.getName(), levelListQy);
        // 全域【所有 / 全国】
        List<IdxBizPvHealthLevel> levelListQg = idxBizPvHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizPvHealthLevel>().eq(IdxBizPvHealthLevel::getAnalysisObjType, "全域").last("limit 4"));
        List<PvHealthIndex> fanHealthIndicesQg = pvHealthIndexMapper.getInfoListByGroupByQgPv(startTime, "pv_health_index_moment", "片区");
        saveBatchPv(fanHealthIndicesQg, "pv_health_index_moment", recDate, WarningPeriodEnum.MINUTES.getName(), levelListQg);
    }

    /**
     * 光伏 -  按小时生成 测点、设备、子阵、场站和片区数据
     */
    @Scheduled(cron = "0 0 0/1 * * ? ")
    public void insertHourDataPv() throws ParseException {
        if (!openHealth) {
            return;
        }
        idxFanHealthIndexMapper.deleteAllDataByTableName("pv_health_index_latest_data", "按小时");
        String recDate = DateUtil.format(new Date(), "yyyy-MM-dd HH:00:00");
        // 8小时 + 59分钟
        String startTime = DateUtils.dateFormat(DateUtils.dateAddMinutes(new Date(), -541), DateUtils.DATE_TIME_PATTERN);
        // 测点
        List<IdxBizPvHealthLevel> levelList = idxBizPvHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizPvHealthLevel>().eq(IdxBizPvHealthLevel::getAnalysisObjType, "测点").last("limit 4"));
        List<PvHealthIndex> fanHealthIndices = pvHealthIndexMapper.getInfoListByGroupByCdPv(startTime, "pv_health_index_moment", "测点");
        saveBatchPv(fanHealthIndices, "pv_health_index_hour", recDate, WarningPeriodEnum.HOUR.getName(), levelList);
        // 设备
        List<IdxBizPvHealthLevel> levelListSb = idxBizPvHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizPvHealthLevel>().eq(IdxBizPvHealthLevel::getAnalysisObjType, "设备").last("limit 4"));
        List<PvHealthIndex> fanHealthIndicesSb = pvHealthIndexMapper.getInfoListByGroupBySbPv(startTime, "pv_health_index_moment", "测点");
        saveBatchPv(fanHealthIndicesSb, "pv_health_index_hour", recDate, WarningPeriodEnum.HOUR.getName(), levelListSb);
        // 子阵
        List<IdxBizPvHealthLevel> levelListZz = idxBizPvHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizPvHealthLevel>().eq(IdxBizPvHealthLevel::getAnalysisObjType, "子阵").last("limit 4"));
        List<PvHealthIndex> fanHealthIndicesZz = pvHealthIndexMapper.getInfoListByGroupByZzPv(startTime, "pv_health_index_moment", "设备");
        saveBatchPv(fanHealthIndicesZz, "pv_health_index_hour", recDate, WarningPeriodEnum.HOUR.getName(), levelListZz);
        // 场站
        List<IdxBizPvHealthLevel> levelListCz = idxBizPvHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizPvHealthLevel>().eq(IdxBizPvHealthLevel::getAnalysisObjType, "场站").last("limit 4"));
        List<PvHealthIndex> fanHealthIndicesCz = pvHealthIndexMapper.getInfoListByGroupByCzPv(startTime, "pv_health_index_moment", "子阵");
        saveBatchPv(fanHealthIndicesCz, "pv_health_index_hour", recDate, WarningPeriodEnum.HOUR.getName(), levelListCz);
        // 片区
        List<IdxBizPvHealthLevel> levelListQy = idxBizPvHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizPvHealthLevel>().eq(IdxBizPvHealthLevel::getAnalysisObjType, "片区").last("limit 4"));
        List<PvHealthIndex> fanHealthIndicesQy = pvHealthIndexMapper.getInfoListByGroupByQyPv(startTime, "pv_health_index_moment", "场站");
        saveBatchPv(fanHealthIndicesQy, "pv_health_index_hour", recDate, WarningPeriodEnum.HOUR.getName(), levelListQy);
        // 全域【所有 / 全国】
        List<IdxBizPvHealthLevel> levelListQg = idxBizPvHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizPvHealthLevel>().eq(IdxBizPvHealthLevel::getAnalysisObjType, "全域").last("limit 4"));
        List<PvHealthIndex> fanHealthIndicesQg = pvHealthIndexMapper.getInfoListByGroupByQgPv(startTime, "pv_health_index_moment", "片区");
        saveBatchPv(fanHealthIndicesQg, "pv_health_index_hour", recDate, WarningPeriodEnum.HOUR.getName(), levelListQg);
    }

    /**
     * 光伏  -  按天生成 测点、设备、子阵、场站和片区数据
     */
    @Scheduled(cron = "0 05 0 1/1 * ? ")
    public void insertDayDataPv() throws ParseException {
        if (!openHealth) {
            return;
        }
        idxFanHealthIndexMapper.deleteAllDataByTableName("pv_health_index_latest_data", WarningPeriodEnum.DAY.getName());
        Date recOriginalDate = new Date();
        recOriginalDate  = DateUtil.offsetDay(recOriginalDate, -1);
        String recDate = DateUtil.format(recOriginalDate, "yyyy-MM-dd");
        List<IdxBizPvHealthLevel> levelList = idxBizPvHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizPvHealthLevel>().eq(IdxBizPvHealthLevel::getAnalysisObjType, "测点").last("limit 4"));
        String startTime = DateUtils.dateFormat(DateUtils.dateAddHours(new Date(), -32), DateUtils.DATE_TIME_PATTERN);
        List<PvHealthIndex> fanHealthIndices = pvHealthIndexMapper.getInfoListByGroupByCdPv(startTime, "pv_health_index_hour", "测点");
        saveBatchPv(fanHealthIndices, "pv_health_index_day", recDate, WarningPeriodEnum.DAY.getName(), levelList);
        // 设备
        List<IdxBizPvHealthLevel> levelListSb = idxBizPvHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizPvHealthLevel>().eq(IdxBizPvHealthLevel::getAnalysisObjType, "设备").last("limit 4"));
        List<PvHealthIndex> fanHealthIndicesSb = pvHealthIndexMapper.getInfoListByGroupBySbPv(startTime, "pv_health_index_hour", "测点");
        saveBatchPv(fanHealthIndicesSb, "pv_health_index_day", recDate, WarningPeriodEnum.DAY.getName(), levelListSb);
        // 子阵
        List<IdxBizPvHealthLevel> levelListZz = idxBizPvHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizPvHealthLevel>().eq(IdxBizPvHealthLevel::getAnalysisObjType, "子阵").last("limit 4"));
        List<PvHealthIndex> fanHealthIndicesZz = pvHealthIndexMapper.getInfoListByGroupByZzPv(startTime, "pv_health_index_hour", "设备");
        saveBatchPv(fanHealthIndicesZz, "pv_health_index_day", recDate, WarningPeriodEnum.DAY.getName(), levelListZz);
        // 场站
        List<IdxBizPvHealthLevel> levelListCz = idxBizPvHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizPvHealthLevel>().eq(IdxBizPvHealthLevel::getAnalysisObjType, "场站").last("limit 4"));
        List<PvHealthIndex> fanHealthIndicesCz = pvHealthIndexMapper.getInfoListByGroupByCzPv(startTime, "pv_health_index_hour", "子阵");
        saveBatchPv(fanHealthIndicesCz, "pv_health_index_day", recDate, WarningPeriodEnum.DAY.getName(), levelListCz);
        // 片区
        List<IdxBizPvHealthLevel> levelListQy = idxBizPvHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizPvHealthLevel>().eq(IdxBizPvHealthLevel::getAnalysisObjType, "片区").last("limit 4"));
        List<PvHealthIndex> fanHealthIndicesQy = pvHealthIndexMapper.getInfoListByGroupByQyPv(startTime, "pv_health_index_hour", "场站");
        saveBatchPv(fanHealthIndicesQy, "pv_health_index_day", recDate, WarningPeriodEnum.DAY.getName(), levelListQy);
        // 全域【所有 / 全国】
        List<IdxBizPvHealthLevel> levelListQg = idxBizPvHealthLevelMapper.selectList(new LambdaQueryWrapper<IdxBizPvHealthLevel>().eq(IdxBizPvHealthLevel::getAnalysisObjType, "全域").last("limit 4"));
        List<PvHealthIndex> fanHealthIndicesQg = pvHealthIndexMapper.getInfoListByGroupByQgPv(startTime, "pv_health_index_hour", "片区");
        saveBatchPv(fanHealthIndicesQg, "pv_health_index_day", recDate, WarningPeriodEnum.DAY.getName(), levelListQg);
    }


    private String getHealthLevelByScorePv(List<IdxBizPvHealthLevel> levelList, Double healthIndex) {
        String levelDesc = "安全";
        for (IdxBizPvHealthLevel item : levelList) {
            if (item.getGroupUpperLimit() >= healthIndex && item.getGroupLowerLimit() < healthIndex) {
                levelDesc = item.getHealthLevel();
                break;
            }
        }
        return levelDesc;
    }

    private void saveBatchPv(List<PvHealthIndex> pvHealthIndices,
                             String tableName,
                             String recDate,
                             String analysisType,
                             List<IdxBizPvHealthLevel> levelList) {
        ArrayList<PvHealthIndex> newList = new ArrayList<>();
        for (int i = 0; i < pvHealthIndices.size(); i++) {
            PvHealthIndex item = pvHealthIndices.get(i);
            item.setRecDate(recDate);
            item.setAnalysisTime(recDate);
            item.setAnalysisType(analysisType);
            item.setHealthLevel(getHealthLevelByScorePv(levelList, item.getHealthIndex()));
            //分批次处理
            newList.add(item);//循环将数据填入载体list
            if (500 == newList.size() || i == pvHealthIndices.size() - 1) {  //载体list达到要求,进行批量操作
                //调用批量插入
                pvHealthIndexMapper.saveBatchHealthIndexList(newList, tableName, analysisType);
                idxFanHealthIndexMapper.saveBatchHealthIndexLatestInfoPv(newList);
                newList.clear();//每次批量操作后,清空载体list,等待下次的数据填入
            }
        }
    }
}
