package com.yeejoin.amos.boot.module.ugp.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.util.Date;

/**
 * 材料信息表
 *
 * @author system_generator
 * @date 2022-09-21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_ugp_material")
public class UgpMaterial extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 名称
     */
	@TableField("name")
    private String name;

    /**
     * 项目id
     */
	@TableField("company_id")
    private Long companyId;

    /**
     * 管材编号
     */
	@TableField("code")
    private String code;

    /**
     * 管材类别
     */
	@TableField("type")
    private String type;

    /**
     * 管材规格
     */
	@TableField("spec")
    private String spec;

    /**
     * 管材壁厚
     */
	@TableField("wall_thickness")
    private Integer wallThickness;

    /**
     * 生产厂家
     */
	@TableField("manufacturer")
    private String manufacturer;

    /**
     * 生产日期
     */
	@TableField("manufacture_date")
    private Date manufactureDate;

    /**
     * 生产编号
     */
	@TableField("batch_num")
    private String batchNum;

    /**
     * 管道直径
     */
	@TableField("diameter")
    private Double diameter;

    /**
     * 管道材料
     */
	@TableField("material")
    private String material;

    /**
     * 管道长度
     */
	@TableField("length")
    private Double length;

    /**
     * 厂家所在地
     */
	@TableField("manufacture_addr")
    private String manufactureAddr;

    /**
     * 是否审批通过（1通过，0未通过）
     */
	@TableField("approved")
    private Boolean approved;

    /**
     * 单位机构代码
     */
	@TableField("org_code")
    private String orgCode;

}
