package com.yeejoin.amos.boot.module.hygf.api.config;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.hygf.api.entity.StdUserEmpower;
import com.yeejoin.amos.boot.module.hygf.api.mapper.UserEmpowerMapper;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.typroject.tyboot.core.foundation.context.RequestContext;

/**
 * @description:
 * @author: tw
 * @createDate: 2023/11/9
 */
@Aspect
@Order(-1)// 保证该AOP在@Transactional之前执行
@Component
@Slf4j
public class UserLimitsAdvice {

    @Autowired
    private UserEmpowerMapper userEmpowerMapper;


    //调用的方法有该注解才会拦截
    @Pointcut("@annotation(com.yeejoin.amos.boot.module.hygf.api.config.UserLimits)")
    private void annotationPointCut() {
    }


    //环绕 满足上面的拦截条件就会调用该方法
    @Around("annotationPointCut()")
    public Object annotationAround(ProceedingJoinPoint joinPoint) throws Throwable {
        //获取方法
//        Method method = ((MethodSignature) joinPoint.getSignature()).getMethod();

        // 获取该方法上的 OpenApi注解
//        UserLimits aspectAnnotation = method.getAnnotation(UserLimits.class);

        String userid=RequestContext.getExeUserId();
        LambdaQueryWrapper<StdUserEmpower> qu=new LambdaQueryWrapper();
        qu.eq(StdUserEmpower::getAmosUserId,userid);
        qu.ne(StdUserEmpower::getPermissionType,"YTH");
        StdUserEmpower list= userEmpowerMapper.selectOne(qu);
        UserEmpowerThreadLocal.setDataAuthRule(list!=null?list.getAmosOrgCode():null);
        //正常往后执行
        return joinPoint.proceed();
    }


}