package com.yeejoin.amos.boot.module.hygf.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 户用光伏监盘逆变器报警表
 *
 * @author system_generator
 * @date 2023-09-19
 */
@Data
@ApiModel(value="TdHygfJpInverterWarnDto", description="户用光伏监盘逆变器报警表")
public class TdHygfJpInverterWarnDto {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "sn编码")
	private String snCode;

	@ApiModelProperty(value = "内容")
	private String content;

	@ApiModelProperty(value = "等级")
	private String level;

	@ApiModelProperty(value = "时长")
	private Long timeLong;

	@ApiModelProperty(value = "起始时间")
	private Long startTime;

	@ApiModelProperty(value = "报警时间")
	private Date startTimeDate;

	@ApiModelProperty(value = "恢复时间")
	private Long recoverTime;

	@ApiModelProperty(value = "恢复时间")
	private Date recoverTimeString;

	@ApiModelProperty(value = "处理方法")
	private String treatment;

	@ApiModelProperty(value = "第三方电站id")
	private String thirdStationId;

	@ApiModelProperty(value = "第三方厂商标识")
	private String thirdCode;

	@ApiModelProperty(value = "状态")
	private String state;

	@ApiModelProperty(value = "时间")
	private Long time;
	
	private String stationName;
	
	private String stationContact;
	
	private String userName;
	
	private String userPhone;
	
	private String email;
	
	private String address;
	
	private String area;
	
	private Long createdTime;
	
	private String timeLongFormat;

	private String startTimeFormat;

	private String recoverTimeFormat;
	
	private List<String> stationIds;
	
	private List<String> states;
    private String name;
    private String handlerStatus;
    private List<String>  listHandlerStatus;


	/**
	 * 场站id
	 */
	private String stationId;

	/**
	 * 业主名称
	 */
	private String ownerName;

	/**
	 * 逆变器sn编码
	 */
	private String inverterSn;
	/**
	 * 告警等级
	 */
	private String warningLevel;
	/**
	 * 告警状态
	 */
	private String warningStatus;
	/**
	 * 告警内容
	 */
	private String warningContent;
	/**
	 * 告警开始时间
	 */

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date warningStartTime;
	/**
	 * 告警开始时间
	 */
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")

	private Date warningEndTime;
	/**
	 * 告警时长
	 */

	private String warningDuration;

	/**
	 * 场站联系人电话
	 */

	private String stationContactPhone;
	/**
	 * 场站地址
	 */

	private String stationAddress;
	/**
	 * 处理附件
	 */
	@TableField(value = "handler_content_attachment",typeHandler = FastjsonTypeHandler.class)
	private List<Object> hanlerContentAttachment;
	/**
	 * 处理方式
	 */

	private String handlerMethod;
	/**
	 * 是否替换备件
	 */

	private Boolean isReplaceSpareParts =false;
	/**
	 * 运维人员附件
	 */
	@TableField(value = "spare_parts_attchment",typeHandler = FastjsonTypeHandler.class)
	private List<Object> sparePartsAttchment;
	/**
	 * 场站运维人员id
	 */

	private String maintenancePersonId;
	/**
	 * 场站经度
	 */

	private String stationLongitude;
	/**
	 * 场站纬度
	 */

	private String stationLatitude;
	/**
	 * 运维人员名称
	 */

	private String maintenancePersonName;
	/**
	 * 运维人员手机号
	 */

	private String maintenancePersonPhone;
	/**
	 * tdengine告警id
	 */

	private Long warningId;
	/**
	 * 区域公司orgCode
	 */

	private String regionalCompaniesCode;

	/**
	 * 经销商orgcode
	 */
	private String amosCompanyCode;

	private String ticketType;

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date taskStartTime;
	/**
	 * 告警开始时间
	 */
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date taskEndTime;

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
	private Date recDate;

}
