package com.yeejoin.amos.boot.module.hygf.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.joda.time.DateTime;

import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName(value = "hygf_maintenance_tickets",autoResultMap = true)
public class HYGFMaintenanceTickets extends BaseEntity {
    private static final long serialVersionUID = 1L;
    /**
     * 工单处理状态
     */
    @TableField("handler_status")
    private String handlerStatus;
    /**
     * 场站id
     */
    @TableField("station_id")
    private String stationId;

    /**
     * 业主名称
     */
    @TableField("owner_name")
    private String ownerName;
    /**
     * 场站名称
     */
    @TableField("station_name")
    private String stationName;
    /**
     * 逆变器sn编码
     */
    @TableField("inverter_sn")
    private String inverterSn;
    /**
     * 告警等级
     */
    @TableField("warning_level")
    private String warningLevel;
    /**
     * 告警状态
     */
    @TableField("warning_status")
    private String warningStatus;
    /**
     * 告警内容
     */
    @TableField("warning_content")
    private String warningContent;
    /**
     * 告警开始时间
     */
    @TableField("warning_start_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date warningStartTime;
    /**
     * 告警开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("warning_end_time")
    private Date warningEndTime;
    /**
     * 告警时长
     */
    @TableField("warning_duration")
    private String warningDuration;
    /**
     * 场站联系人
     */
    @TableField("station_contact")
    private String stationContact;
    /**
     * 场站联系人电话
     */
    @TableField("station_contact_phone")
    private String stationContactPhone;
    /**
     * 场站地址
     */
    @TableField("station_address")
    private String stationAddress;
    /**
     * 处理附件
     */
    @TableField(value = "handler_content_attachment",typeHandler = FastjsonTypeHandler.class)
    private List<Object> hanlerContentAttachment;
    /**
     * 处理方式
     */
    @TableField("handler_method")
    private String handlerMethod;
    /**
     * 是否替换备件
     */
    @TableField("is_repleace_spare_parts")
    private Boolean isReplaceSpareParts =false;
    /**
     * 运维人员附件
     */
    @TableField(value = "spare_parts_attchment",typeHandler = FastjsonTypeHandler.class)
    private List<Object> sparePartsAttchment;
    /**
     * 场站运维人员id
     */
    @TableField("maintenance_person_id")
    private String maintenancePersonId;
    /**
     * 场站经度
     */
    @TableField("station_longitude")
    private String stationLongitude;
    /**
     * 场站纬度
     */
    @TableField("station_latitude")
    private String stationLatitude;
    /**
     * 运维人员名称
     */
    @TableField("maintenance_person_name")
    private String maintenancePersonName;
    /**
     * 运维人员手机号
     */
    @TableField("maintenance_person_phone")
    private String maintenancePersonPhone;
    /**
     * tdengine告警id
     */
    @TableField("warning_id")
    private Long warningId;
    /**
     * 区域公司orgCode
     */
    @TableField("regional_companies_code")
    private String regionalCompaniesCode;

    /**
     * 经销商orgcode
     */
    @TableField("amos_company_code")
    private String amosCompanyCode;
    @TableField("ticket_type")
    private String ticketType;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("task_start_time")
    private Date taskStartTime;
    /**
     * 告警开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @TableField("task_end_time")
    private Date taskEndTime;

}
