package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.dto.ConstructionRecordsDto;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.ConstructionRecordsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 施工日志
 *
 * @author system_generator
 * @date 2024-01-15
 */
@RestController
@Api(tags = "施工日志Api")
@RequestMapping(value = "/construction-records")
public class ConstructionRecordsController extends BaseController {

    @Autowired
    ConstructionRecordsServiceImpl constructionRecordsServiceImpl;

    /**
     * 新增施工日志
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增施工日志", notes = "新增施工日志")
	public ResponseModel<ConstructionRecordsDto> save(@RequestBody ConstructionRecordsDto model) {
	    model = constructionRecordsServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新施工日志", notes = "根据sequenceNbr更新施工日志")
	public ResponseModel<ConstructionRecordsDto> updateBySequenceNbrConstructionRecords(@RequestBody ConstructionRecordsDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(constructionRecordsServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除施工日志", notes = "根据sequenceNbr删除施工日志")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(constructionRecordsServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个施工日志",  notes = "根据sequenceNbr查询单个施工日志")
	public ResponseModel<ConstructionRecordsDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(constructionRecordsServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "施工日志分页查询",  notes = "施工日志分页查询")
	public ResponseModel<Page<ConstructionRecordsDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<ConstructionRecordsDto> page = new Page<ConstructionRecordsDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(constructionRecordsServiceImpl.queryForConstructionRecordsPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "施工日志列表全部数据查询",   notes = "施工日志列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<ConstructionRecordsDto>> selectForList() {
	    return ResponseHelper.buildResponse(constructionRecordsServiceImpl.queryForConstructionRecordsList());
	}
}
