package com.yeejoin.amos.boot.module.hygf.biz.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.hygf.api.dto.HYGFMaintenanceTicketsDto;
import com.yeejoin.amos.boot.module.hygf.api.entity.HYGFMaintenanceTickets;
import com.yeejoin.amos.boot.module.hygf.biz.service.impl.HYGFMaintenanceTicketsServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * 运维工单
 *
 * @author system_generator
 * @date 2024-03-11
 */
@RestController
@Api(tags = "运维工单Api")
@RequestMapping(value = "/maintenanceTickets")
public class HYGFMaintenanceTicketsController extends BaseController {

    @Autowired
	HYGFMaintenanceTicketsServiceImpl hygfMaintenanceTicketsServiceimpl;

    /**
     * 新增运维工单
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增运维工单", notes = "新增运维工单")
	public ResponseModel<HYGFMaintenanceTicketsDto> save(@RequestBody HYGFMaintenanceTicketsDto model) {
	   hygfMaintenanceTicketsServiceimpl.sendMeassageToMcb(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/update")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新运维工单", notes = "根据sequenceNbr更新运维工单")
	public ResponseModel<HYGFMaintenanceTicketsDto> updateBySequenceNbrMaintenance(@RequestBody HYGFMaintenanceTicketsDto model) {
	    return ResponseHelper.buildResponse(hygfMaintenanceTicketsServiceimpl.updateHYGFMaintenanceTicketsDto(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除运维工单", notes = "根据sequenceNbr删除运维工单")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(hygfMaintenanceTicketsServiceimpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping(value = "/getDeatil")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个运维工单",  notes = "根据sequenceNbr查询单个运维工单")
	public ResponseModel<HYGFMaintenanceTickets> selectOne(@RequestParam Long sequenceNbr) {
	    return ResponseHelper.buildResponse(hygfMaintenanceTicketsServiceimpl.getDetailBySequenceNbr(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "运维工单分页查询",  notes = "运维工单分页查询")
	public ResponseModel<Page<HYGFMaintenanceTicketsDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size, HYGFMaintenanceTicketsDto hygfMaintenanceTicketsDto) {

	    return ResponseHelper.buildResponse(hygfMaintenanceTicketsServiceimpl.queryForHYGFMaintenanceTicketsDtoPage(current,size,hygfMaintenanceTicketsDto));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "运维工单列表全部数据查询",   notes = "运维工单列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<HYGFMaintenanceTicketsDto>> selectForList() {
	    return ResponseHelper.buildResponse(hygfMaintenanceTicketsServiceimpl.queryHYGFMaintenanceTicketsDtoList());
	}
	/**
	 * 列表全部数据查询
	 *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY,needAuth = false)
	@ApiOperation(httpMethod = "GET",value = "根据场站id获取sncode列表",   notes = "根据场站id获取sncode列表")
	@GetMapping(value = "/queryInverterSncodesByStationId")
	public ResponseModel<List<String>> queryInverterSncodesByStationId(@RequestParam(value = "stationId") String stationId){
		return ResponseHelper.buildResponse(hygfMaintenanceTicketsServiceimpl.queryInverterSncodesByStationId(stationId));
	}
}
