package com.yeejoin.amos.boot.module.jxiop.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jxiop.api.entity.StationBasic;
import com.yeejoin.amos.boot.module.jxiop.api.mapper.StationBasicMapper;
import com.yeejoin.amos.boot.module.jxiop.api.service.IPermissionService;
import com.yeejoin.amos.boot.module.jxiop.biz.amosprojectmapper.UserEmpowerMapper;
import com.yeejoin.amos.boot.module.jxiop.biz.entity.StdUserEmpower;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Service
public class IPermissionServiceImpl implements IPermissionService {

    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    private UserEmpowerMapper userEmpowerMapper;

    @Autowired
    private StationBasicMapper stationBasicMapper;

    @Override
    public List<String> getCurrentUserPermissions() {
        List<String> result = new ArrayList<>();
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        String userId = reginParams.getUserModel().getUserId();
        StdUserEmpower stdUserEmpower = userEmpowerMapper.selectOne(new QueryWrapper<StdUserEmpower>().eq("amos_user_id", userId).eq("permission_type", "YTH"));
        if (ObjectUtils.isEmpty(stdUserEmpower)) {
            return null;
        } else {
            String permissionOrgCode = stdUserEmpower.getAmosOrgCode().get(0);
            Map<String, String> companyInfo = userEmpowerMapper.getCompanyInfoByOrgCode(permissionOrgCode);
            String companyLevel = companyInfo.get("level");
            if (companyLevel.equals("categroy_leve2")) {
                return null;
            }
            if (companyLevel.equals("area")) {
                List<StationBasic> stationBasics = stationBasicMapper.selectList(new QueryWrapper<StationBasic>().like("project_org_code", permissionOrgCode));
                result = stationBasics.stream().map(StationBasic::getFanGatewayId).collect(Collectors.toList());
                return result;
            }
            if (companyLevel.equals("station")) {
                StationBasic stationBasic = stationBasicMapper.selectOne(new QueryWrapper<StationBasic>().eq("project_org_code", permissionOrgCode));
                result.add(stationBasic.getFanGatewayId());
                return result;
            }
        }
        return result;
    }

    @Override
    public List<String> getCurrentUserProjectOrgCodes() {
        List<String> result = new ArrayList<>();
        ReginParams reginParams = JSONObject.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(), RequestContext.getToken())).toString(), ReginParams.class);
        String userId = reginParams.getUserModel().getUserId();
        StdUserEmpower stdUserEmpower = userEmpowerMapper.selectOne(new QueryWrapper<StdUserEmpower>().eq("amos_user_id", userId).eq("permission_type", "YTH"));
        if (ObjectUtils.isEmpty(stdUserEmpower)) {
            return null;
        } else {
            String permissionOrgCode = stdUserEmpower.getAmosOrgCode().get(0);
            Map<String, String> companyInfo = userEmpowerMapper.getCompanyInfoByOrgCode(permissionOrgCode);
            String companyLevel = companyInfo.get("level");
            if (companyLevel.equals("categroy_leve2")) {
                return null;
            }
            if (companyLevel.equals("area")) {
                List<StationBasic> stationBasics = stationBasicMapper.selectList(new QueryWrapper<StationBasic>().like("project_org_code", permissionOrgCode));
                result = stationBasics.stream().map(StationBasic::getProjectOrgCode).collect(Collectors.toList());
                return result;
            }
            if (companyLevel.equals("station")) {
                StationBasic stationBasic = stationBasicMapper.selectOne(new QueryWrapper<StationBasic>().eq("project_org_code", permissionOrgCode));
                result.add(stationBasic.getProjectOrgCode());
                return result;
            }
        }
        return result;
    }
}
