package com.yeejoin.precontrol.common.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import java.util.Date;
import com.yeejoin.precontrol.common.entity.publics.BaseEntity;

import cn.afterturn.easypoi.excel.annotation.Excel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
/**
 * 项目关联分包商表
 *
 * @author duanwei
 * @date 2022-06-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("rpm_project_company_filling")
@ApiModel(value="ProjectCompanyFilling对象", description="项目关联分包商表")
public class ProjectCompanyFilling extends BaseEntity {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "项目id")
    private Long projectId;

    @ApiModelProperty(value = "分包商id")
    private Long companyId;

    @ApiModelProperty(value = "填报月份")
    @Excel(name = "填报月份")
    private Date fillMonth;

    private Long fillPersonId;

    @Excel(name = "分包商人数")
    private Integer personCount;

    @Excel(name = "发放工资人数")
    private Integer payCount;

    @Excel(name = "合计应发工资")
    private Double totalSalary;

    @Excel(name = "合计实发工资")
    private Double actualSalary;

    @Excel(name = "应发差额")
    private Double differentSalary;

    @Excel(name = "养老保险")
    private Double endowmentInsurance;

    @Excel(name = "医疗保险")
    private Double medicalInsurance;

    @Excel(name = "工商保险")
    private Double injuryInsurance;

    @Excel(name = "其他金额")
    private Double otherAmounts;
}
