package com.yeejoin.amos.boot.module.tzs.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;
import java.util.Date;

/**
 * 
 *
 * @author litw
 * @date 2021-09-28
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="ElevatorStatusDto", description="")
public class ElevatorStatusDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "电梯注册码")
    private String registerCode;

    @ApiModelProperty(value = "原始状态编号")
    private String statusId;

    @ApiModelProperty(value = "是否在线。1：是，0：否")
    private Integer isOnline;

    @ApiModelProperty(value = "运行数据上传时间")
    private Date uploadDate;

    @ApiModelProperty(value = "总接触器吸合或是断开。0：吸合，1：断开")
    private Integer mainContactor;

    @ApiModelProperty(value = "运行接触器吸合或是断开。0：吸合，1：断开")
    private Integer runContactor;

    @ApiModelProperty(value = "安全回路是否断开，0：正常，1：断开")
    private Integer circuit;

    @ApiModelProperty(value = "当前电梯运行模式。1：停止服务 2：正常运行 3：检修 4：消防返回 5：消防员运行 6：应急电源运行 7：地震模式 8: 未知")
    private Integer serviceModel;

    @ApiModelProperty(value = "轿厢运行状态。1：停止，2：运行")
    private Integer liftStatus;

    @ApiModelProperty(value = "轿厢运行方向。1：无方向 2：上行 3：下行")
    private Integer liftDirection;

    @ApiModelProperty(value = "轿厢是否在门区。1：轿厢在门区 0：轿厢在非门区")
    private Integer isZone;

    @ApiModelProperty(value = "运行速度")
    private Integer elevatorSpeed;

    @ApiModelProperty(value = "当前物理楼层")
    private Integer currFloor;

    @ApiModelProperty(value = "关门到位 1：关门到位，0：无关门到位信号")
    private Integer doorStatus;

    @ApiModelProperty(value = "上极限是否动作 0:否，1：是")
    private Integer upLimit;

    @ApiModelProperty(value = "下极限是否动作 0:否，1：是")
    private Integer downLimit;

    @ApiModelProperty(value = "轿厢报警按钮是否动作 0:否，1：是")
    private Integer alarm;

    @ApiModelProperty(value = "轿厢内是否有人 0：无，1：有")
    private Integer personFlag;

    @ApiModelProperty(value = "累计运行小时数，保留到小数点后两位")
    private Double hours;

    @ApiModelProperty(value = "累计运行次数")
    private Integer runCount;

}
